/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.jupiter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.toolchain.test.FS;

public class WorkDir {
    private final Path path;

    public WorkDir(Path path) {
        this.path = path;
    }

    public Path getPath() {
        if (Files.exists(this.path, new LinkOption[0])) {
            return this.path;
        }
        FS.ensureDirExists(this.path);
        try {
            return this.path.normalize().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to obtain real path: " + this.path, e);
        }
    }

    public Path getPathFile(String name) {
        return this.path.resolve(name);
    }

    public void ensureEmpty() {
        FS.ensureEmpty(this.path);
    }

    public Path getEmptyPathDir() {
        FS.ensureEmpty(this.path);
        return this.path;
    }
}

