/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.XmlEncodingBase;

public class SecurityCollection
extends XmlEncodingBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description = null;
    private String[] methods = new String[0];
    private String[] omittedMethods = new String[0];
    private String name = null;
    private String[] patterns = new String[0];
    private boolean isFromDescriptor = true;

    public SecurityCollection() {
        this(null, null);
    }

    public SecurityCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFromDescriptor() {
        return this.isFromDescriptor;
    }

    public void setFromDescriptor(boolean isFromDescriptor) {
        this.isFromDescriptor = isFromDescriptor;
    }

    public void addMethod(String method) {
        if (method == null) {
            return;
        }
        String[] results = new String[this.methods.length + 1];
        for (int i2 = 0; i2 < this.methods.length; ++i2) {
            results[i2] = this.methods[i2];
        }
        results[this.methods.length] = method;
        this.methods = results;
    }

    public void addOmittedMethod(String method) {
        if (method == null) {
            return;
        }
        String[] results = new String[this.omittedMethods.length + 1];
        for (int i2 = 0; i2 < this.omittedMethods.length; ++i2) {
            results[i2] = this.omittedMethods[i2];
        }
        results[this.omittedMethods.length] = method;
        this.omittedMethods = results;
    }

    public void addPattern(String pattern) {
        this.addPatternDecoded(UDecoder.URLDecode(pattern, StandardCharsets.UTF_8));
    }

    public void addPatternDecoded(String pattern) {
        if (pattern == null) {
            return;
        }
        String decodedPattern = UDecoder.URLDecode(pattern);
        String[] results = new String[this.patterns.length + 1];
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            results[i2] = this.patterns[i2];
        }
        results[this.patterns.length] = decodedPattern;
        this.patterns = results;
    }

    public boolean findMethod(String method) {
        if (this.methods.length == 0 && this.omittedMethods.length == 0) {
            return true;
        }
        if (this.methods.length > 0) {
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                if (!this.methods[i2].equals(method)) continue;
                return true;
            }
            return false;
        }
        if (this.omittedMethods.length > 0) {
            for (int i3 = 0; i3 < this.omittedMethods.length; ++i3) {
                if (!this.omittedMethods[i3].equals(method)) continue;
                return false;
            }
        }
        return true;
    }

    public String[] findMethods() {
        return this.methods;
    }

    public String[] findOmittedMethods() {
        return this.omittedMethods;
    }

    public boolean findPattern(String pattern) {
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            if (!this.patterns[i2].equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public String[] findPatterns() {
        return this.patterns;
    }

    public void removeMethod(String method) {
        if (method == null) {
            return;
        }
        int n = -1;
        for (int i2 = 0; i2 < this.methods.length; ++i2) {
            if (!this.methods[i2].equals(method)) continue;
            n = i2;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.methods.length - 1];
            for (int i3 = 0; i3 < this.methods.length; ++i3) {
                if (i3 == n) continue;
                results[j++] = this.methods[i3];
            }
            this.methods = results;
        }
    }

    public void removeOmittedMethod(String method) {
        if (method == null) {
            return;
        }
        int n = -1;
        for (int i2 = 0; i2 < this.omittedMethods.length; ++i2) {
            if (!this.omittedMethods[i2].equals(method)) continue;
            n = i2;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.omittedMethods.length - 1];
            for (int i3 = 0; i3 < this.omittedMethods.length; ++i3) {
                if (i3 == n) continue;
                results[j++] = this.omittedMethods[i3];
            }
            this.omittedMethods = results;
        }
    }

    public void removePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        int n = -1;
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            if (!this.patterns[i2].equals(pattern)) continue;
            n = i2;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.patterns.length - 1];
            for (int i3 = 0; i3 < this.patterns.length; ++i3) {
                if (i3 == n) continue;
                results[j++] = this.patterns[i3];
            }
            this.patterns = results;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SecurityCollection[");
        sb.append(this.name);
        if (this.description != null) {
            sb.append(", ");
            sb.append(this.description);
        }
        sb.append("]");
        return sb.toString();
    }
}

