/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ParamParent;

public abstract class ParamSupport
extends BodyTagSupport {
    protected String name;
    protected String value;
    protected boolean encode = true;

    public ParamSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
        this.name = null;
    }

    public int doEndTag() throws JspException {
        Tag t = ParamSupport.findAncestorWithClass(this, ParamParent.class);
        if (t == null) {
            throw new JspTagException(Resources.getMessage("PARAM_OUTSIDE_PARENT"));
        }
        if (this.name == null || this.name.equals("")) {
            return 6;
        }
        ParamParent parent = (ParamParent)((Object)t);
        String value = this.value;
        if (value == null) {
            value = this.bodyContent == null || this.bodyContent.getString() == null ? "" : this.bodyContent.getString().trim();
        }
        if (this.encode) {
            String enc = this.pageContext.getResponse().getCharacterEncoding();
            try {
                parent.addParameter(URLEncoder.encode(this.name, enc), URLEncoder.encode(value, enc));
            }
            catch (UnsupportedEncodingException e) {
                throw new JspTagException(e);
            }
        } else {
            parent.addParameter(this.name, value);
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    public static class ParamManager {
        private List names = new LinkedList();
        private List values = new LinkedList();
        private boolean done = false;

        public void addParameter(String name, String value) {
            if (this.done) {
                throw new IllegalStateException();
            }
            if (name != null) {
                this.names.add(name);
                if (value != null) {
                    this.values.add(value);
                } else {
                    this.values.add("");
                }
            }
        }

        public String aggregateParams(String url) {
            if (this.done) {
                throw new IllegalStateException();
            }
            this.done = true;
            StringBuffer newParams = new StringBuffer();
            for (int i2 = 0; i2 < this.names.size(); ++i2) {
                newParams.append(this.names.get(i2) + "=" + this.values.get(i2));
                if (i2 >= this.names.size() - 1) continue;
                newParams.append("&");
            }
            if (newParams.length() > 0) {
                int questionMark = url.indexOf(63);
                if (questionMark == -1) {
                    return url + "?" + newParams;
                }
                StringBuffer workingUrl = new StringBuffer(url);
                workingUrl.insert(questionMark + 1, newParams + "&");
                return workingUrl.toString();
            }
            return url;
        }
    }
}

