/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Set;
import javax.servlet.http.PushBuilder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBuilderImpl
implements PushBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PushBuilderImpl.class);
    private static final HttpField JettyPush = new HttpField("x-http2-push", "PushBuilder");
    private final Request _request;
    private final HttpFields _fields;
    private String _method;
    private String _queryString;
    private String _sessionId;
    private String _path;
    private String _lastModified;

    public PushBuilderImpl(Request request, HttpFields fields, String method, String queryString, String sessionId) {
        this._request = request;
        this._fields = fields;
        this._method = method;
        this._queryString = queryString;
        this._sessionId = sessionId;
        this._fields.add(JettyPush);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PushBuilder({} {}?{} s={} c={})", new Object[]{this._method, this._request.getRequestURI(), this._queryString, this._sessionId});
        }
    }

    public String getMethod() {
        return this._method;
    }

    public PushBuilder method(String method) {
        this._method = method;
        return this;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public PushBuilder queryString(String queryString) {
        this._queryString = queryString;
        return this;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public PushBuilder sessionId(String sessionId) {
        this._sessionId = sessionId;
        return this;
    }

    public Set<String> getHeaderNames() {
        return this._fields.getFieldNamesCollection();
    }

    public String getHeader(String name) {
        return this._fields.get(name);
    }

    public PushBuilder setHeader(String name, String value) {
        this._fields.put(name, value);
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        this._fields.add(name, value);
        return this;
    }

    public PushBuilder removeHeader(String name) {
        this._fields.remove(name);
        return this;
    }

    public String getPath() {
        return this._path;
    }

    public PushBuilder path(String path) {
        this._path = path;
        return this;
    }

    public void push() {
        if (HttpMethod.POST.is(this._method) || HttpMethod.PUT.is(this._method)) {
            throw new IllegalStateException("Bad Method " + this._method);
        }
        if (this._path == null || this._path.length() == 0) {
            throw new IllegalStateException("Bad Path " + this._path);
        }
        String path = this._path;
        String query = this._queryString;
        int q = path.indexOf(63);
        if (q >= 0) {
            query = query != null && query.length() > 0 ? path.substring(q + 1) + "&" + query : path.substring(q + 1);
            path = path.substring(0, q);
        }
        if (!path.startsWith("/")) {
            path = URIUtil.addPaths((String)this._request.getContextPath(), (String)path);
        }
        String param = null;
        if (this._sessionId != null && this._request.isRequestedSessionIdFromURL()) {
            param = "jsessionid=" + this._sessionId;
        }
        HttpURI uri = HttpURI.createHttpURI((String)this._request.getScheme(), (String)this._request.getServerName(), (int)this._request.getServerPort(), (String)path, (String)param, (String)query, null);
        MetaData.Request push = new MetaData.Request(this._method, uri, this._request.getHttpVersion(), this._fields);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Push {} {} inm={} ims={}", new Object[]{this._method, uri, this._fields.get(HttpHeader.IF_NONE_MATCH), this._fields.get(HttpHeader.IF_MODIFIED_SINCE)});
        }
        this._request.getHttpChannel().getHttpTransport().push(push);
        this._path = null;
        this._lastModified = null;
    }
}

