/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.AsyncRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends HandlerWrapper
implements Attributes {
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private static String _version = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : "7.0.x";
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private Container _container = new Container();
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private AttributesMap _attributes = new AttributesMap();
    private List<Object> _dependentBeans = new ArrayList<Object>();
    private int _graceful = 0;

    public Server() {
        this.setServer(this);
    }

    public Server(int port) {
        this.setServer(this);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
    }

    public static String getVersion() {
        return _version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray((Object[])this.getConnectors(), (Object)connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray((Object[])this.getConnectors(), (Object)connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, (Object[])this._connectors, (Object[])connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, (Object)this._threadPool, (Object)threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        Log.info((String)("jetty-" + _version));
        HttpGenerator.setServerVersion((String)_version);
        MultiException mex = new MultiException();
        Iterator<Object> itor = this._dependentBeans.iterator();
        while (itor.hasNext()) {
            try {
                Object o = itor.next();
                if (!(o instanceof LifeCycle)) continue;
                ((LifeCycle)o).start();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        if (this._threadPool == null) {
            QueuedThreadPool tp = new QueuedThreadPool();
            this.setThreadPool((ThreadPool)tp);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.start();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)this._threadPool).start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            Log.warn((String)"Error starting handlers", (Throwable)e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this._graceful > 0) {
            if (this._connectors != null) {
                int i = this._connectors.length;
                while (i-- > 0) {
                    Log.info((String)"Graceful shutdown {}", (Object)this._connectors[i]);
                    try {
                        this._connectors[i].close();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
            Handler[] contexts = this.getChildHandlersByClass(Graceful.class);
            for (int c = 0; c < contexts.length; ++c) {
                Graceful context = (Graceful)contexts[c];
                Log.info((String)"Graceful shutdown {}", (Object)context);
                context.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.stop();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)this._threadPool).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (!this._dependentBeans.isEmpty()) {
            ListIterator<Object> itor = this._dependentBeans.listIterator(this._dependentBeans.size());
            while (itor.hasPrevious()) {
                try {
                    Object o = itor.previous();
                    if (!(o instanceof LifeCycle)) continue;
                    ((LifeCycle)o).stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        Request request = connection.getRequest();
        Response response = connection.getResponse();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("REQUEST " + target + " on " + connection));
            this.handle(target, request, response);
            Log.debug((String)("RESPONSE " + target + "  " + connection.getResponse().getStatus()));
        } else {
            this.handle(target, request, response);
        }
    }

    public void handleAsync(HttpConnection connection) throws IOException, ServletException {
        AsyncRequest async = connection.getRequest().getAsyncRequest();
        AsyncRequest.AsyncEventState state = async.getAsyncEventState();
        Request base_request = connection.getRequest();
        String path = state.getPath();
        if (path != null) {
            base_request.setAttribute("javax.servlet.async.request_uri", base_request.getRequestURI());
            base_request.setAttribute("javax.servlet.async.query_string", base_request.getQueryString());
            base_request.setAttribute("javax.servlet.async.context_path", state.getSuspendedContext().getContextPath());
            String contextPath = state.getServletContext().getContextPath();
            HttpURI uri = new HttpURI(URIUtil.addPaths((String)contextPath, (String)path));
            base_request.setUri(uri);
            base_request.setRequestURI(null);
            base_request.setPathInfo(base_request.getRequestURI());
            base_request.setQueryString(uri.getQuery());
        }
        String target = base_request.getPathInfo();
        HttpServletRequest request = (HttpServletRequest)async.getRequest();
        HttpServletResponse response = (HttpServletResponse)async.getResponse();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("REQUEST " + target + " on " + connection));
            this.handle(target, request, response);
            Log.debug((String)("RESPONSE " + target + "  " + connection.getResponse().getStatus()));
        } else {
            this.handle(target, request, response);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._container.update((Object)this, (Object)this._sessionIdManager, (Object)sessionIdManager, "sessionIdManager", true);
        this._sessionIdManager = sessionIdManager;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void addLifeCycle(LifeCycle c) {
        this.addBean(c);
    }

    public void addBean(Object o) {
        if (o == null) {
            return;
        }
        if (!this._dependentBeans.contains(o)) {
            this._dependentBeans.add(o);
            this._container.addBean(o);
        }
        try {
            if (this.isStarted() && o instanceof LifeCycle) {
                ((LifeCycle)o).start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Object o : this._dependentBeans) {
            if (!clazz.isInstance(o)) continue;
            beans.add(o);
        }
        return beans;
    }

    public void removeLifeCycle(LifeCycle c) {
        this.removeBean(c);
    }

    public void removeBean(Object o) {
        if (o == null) {
            return;
        }
        this._dependentBeans.remove(o);
        this._container.removeBean(o);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int timeoutMS) {
        this._graceful = timeoutMS;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public static interface Graceful
    extends Handler {
        public void setShutdown(boolean var1);
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug((String)"No shutdown hook in JVM ", (Object)e);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection c) {
            this.createShutdownHook();
            return this.servers.addAll(c);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection c) {
            this.createShutdownHook();
            return this.servers.removeAll(c);
        }

        public void run() {
            this.setName("Shutdown");
            Log.info((String)"Shutdown hook executing");
            for (Server svr : this.servers) {
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
                Log.info((String)"Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
        }
    }
}

