/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;

public class RequestLogHandler
extends HandlerWrapper {
    private RequestLog _requestLog;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Request base_request;
        super.handle(target, request, response);
        Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        if (DispatcherType.REQUEST.equals((Object)base_request.getDispatcherType()) && this._requestLog != null) {
            this._requestLog.log((Request)request, (Response)response);
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)this._requestLog, (Object)requestLog, "logimpl", true);
        }
        this._requestLog = requestLog;
        try {
            if (this.isStarted() && this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setServer(Server server) {
        if (this._requestLog != null) {
            if (this.getServer() != null && this.getServer() != server) {
                this.getServer().getContainer().update((Object)this, (Object)this._requestLog, null, "logimpl", true);
            }
            super.setServer(server);
            if (server != null && server != this.getServer()) {
                server.getContainer().update((Object)this, null, (Object)this._requestLog, "logimpl", true);
            }
        } else {
            super.setServer(server);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._requestLog != null) {
            this._requestLog.start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._requestLog != null) {
            this._requestLog.stop();
        }
    }
}

