/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<LocalEndPoint> _connects = new LinkedBlockingQueue<LocalEndPoint>();

    public LocalConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, factories);
        this.setIdleTimeout(30000L);
    }

    public LocalConnector(Server server) {
        this(server, null, null, null, -1, new HttpConnectionFactory());
    }

    public LocalConnector(Server server, SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory) {
        this(server, null, null, null, -1, connectionFactory);
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, connectionFactory));
    }

    @Override
    public Object getTransport() {
        return this;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, 5L, TimeUnit.SECONDS);
    }

    public String getResponses(String requests, long idleFor, TimeUnit units) throws Exception {
        ByteBuffer result = this.getResponses(BufferUtil.toBuffer((String)requests, (Charset)StandardCharsets.UTF_8), idleFor, units);
        return result == null ? null : BufferUtil.toString((ByteBuffer)result, (Charset)StandardCharsets.UTF_8);
    }

    public ByteBuffer getResponses(ByteBuffer requestsBuffer) throws Exception {
        return this.getResponses(requestsBuffer, 5L, TimeUnit.SECONDS);
    }

    public ByteBuffer getResponses(ByteBuffer requestsBuffer, long idleFor, TimeUnit units) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        endp.waitUntilClosedOrIdleFor(idleFor, units);
        ByteBuffer responses = endp.takeOutput();
        if (endp.isOutputShutdown()) {
            endp.close();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("responses {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)responses)});
        }
        return responses;
    }

    public LocalEndPoint executeRequest(String rawRequest) {
        return this.executeRequest(BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.UTF_8));
    }

    private LocalEndPoint executeRequest(ByteBuffer rawRequest) {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED");
        }
        LocalEndPoint endp = new LocalEndPoint();
        endp.addInput(rawRequest);
        this._connects.add(endp);
        return endp;
    }

    public LocalEndPoint connect() {
        LocalEndPoint endp = new LocalEndPoint();
        this._connects.add(endp);
        return endp;
    }

    @Override
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("accepting {}", (long)acceptorID);
        }
        LocalEndPoint endPoint = this._connects.take();
        Connection connection = this.getDefaultConnectionFactory().newConnection(this, (EndPoint)endPoint);
        endPoint.setConnection(connection);
        endPoint.onOpen();
        this.onEndPointOpened((EndPoint)endPoint);
        connection.onOpen();
    }

    public ByteBuffer getResponse(ByteBuffer requestsBuffer) throws Exception {
        return this.getResponse(requestsBuffer, false, 10L, TimeUnit.SECONDS);
    }

    public ByteBuffer getResponse(ByteBuffer requestBuffer, long time, TimeUnit unit) throws Exception {
        boolean head = BufferUtil.toString((ByteBuffer)requestBuffer).toLowerCase().startsWith("head ");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestBuffer);
        return endp.waitForResponse(head, time, unit);
    }

    public ByteBuffer getResponse(ByteBuffer requestBuffer, boolean head, long time, TimeUnit unit) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestBuffer);
        return endp.waitForResponse(head, time, unit);
    }

    public String getResponse(String rawRequest) throws Exception {
        return this.getResponse(rawRequest, false, 30L, TimeUnit.SECONDS);
    }

    public String getResponse(String rawRequest, long time, TimeUnit unit) throws Exception {
        boolean head = rawRequest.toLowerCase().startsWith("head ");
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("request {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        return BufferUtil.toString((ByteBuffer)endp.waitForResponse(head, time, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    public String getResponse(String rawRequest, boolean head, long time, TimeUnit unit) throws Exception {
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("request {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)requestsBuffer)});
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        return BufferUtil.toString((ByteBuffer)endp.waitForResponse(head, time, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    public class LocalEndPoint
    extends ByteArrayEndPoint {
        private final CountDownLatch _closed;
        private ByteBuffer _responseData;

        public LocalEndPoint() {
            super(LocalConnector.this.getScheduler(), LocalConnector.this.getIdleTimeout());
            this._closed = new CountDownLatch(1);
            this.setGrowOutput(true);
        }

        protected void execute(Runnable task) {
            LocalConnector.this.getExecutor().execute(task);
        }

        public void close() {
            boolean wasOpen = this.isOpen();
            super.close();
            if (wasOpen) {
                this.getConnection().onClose();
                this.onClose();
            }
        }

        public void onClose() {
            LocalConnector.this.onEndPointClosed((EndPoint)this);
            super.onClose();
            this._closed.countDown();
        }

        public void shutdownOutput() {
            super.shutdownOutput();
            this.close();
        }

        public void waitUntilClosed() {
            while (this.isOpen()) {
                try {
                    if (this._closed.await(10L, TimeUnit.SECONDS)) continue;
                    break;
                }
                catch (Exception e) {
                    LocalConnector.this.LOG.warn((Throwable)e);
                }
            }
        }

        public void waitUntilClosedOrIdleFor(long idleFor, TimeUnit units) {
            Thread.yield();
            int size = this.getOutput().remaining();
            while (this.isOpen()) {
                try {
                    if (this._closed.await(idleFor, units)) continue;
                    if (size == this.getOutput().remaining()) {
                        if (LocalConnector.this.LOG.isDebugEnabled()) {
                            LocalConnector.this.LOG.debug("idle for {} {}", new Object[]{idleFor, units});
                        }
                        return;
                    }
                    size = this.getOutput().remaining();
                }
                catch (Exception e) {
                    LocalConnector.this.LOG.warn((Throwable)e);
                }
            }
        }

        public String getResponse() throws Exception {
            return this.getResponse(false, 30L, TimeUnit.SECONDS);
        }

        public String getResponse(boolean head, long time, TimeUnit unit) throws Exception {
            ByteBuffer response = this.waitForResponse(head, time, unit);
            if (response != null) {
                return BufferUtil.toString((ByteBuffer)response);
            }
            return null;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer waitForResponse(boolean head, long time, TimeUnit unit) throws Exception {
            handler = new HttpParser.ResponseHandler(){

                public void parsedHeader(HttpField field) {
                }

                public boolean contentComplete() {
                    return false;
                }

                public boolean messageComplete() {
                    return true;
                }

                public boolean headerComplete() {
                    return false;
                }

                public int getHeaderCacheSize() {
                    return 0;
                }

                public void earlyEOF() {
                }

                public boolean content(ByteBuffer item) {
                    return false;
                }

                public void badMessage(int status, String reason) {
                }

                public boolean startResponse(HttpVersion version, int status, String reason) {
                    return false;
                }
            };
            parser = new HttpParser(handler);
            parser.setHeadResponse(head);
            bout = new ByteArrayOutputStream2();
            try {
                block15: {
                    block7: while (true) {
                        if (BufferUtil.hasContent((ByteBuffer)this._responseData)) {
                            chunk = this._responseData;
                        } else {
                            chunk = this.waitForOutput(time, unit);
                            if (BufferUtil.isEmpty((ByteBuffer)chunk) && (!this.isOpen() || this.isOutputShutdown())) {
                                parser.atEOF();
                                parser.parseNext(BufferUtil.EMPTY_BUFFER);
                                break block15;
                            }
                        }
                        do {
                            if (!BufferUtil.hasContent((ByteBuffer)chunk)) continue block7;
                            pos = chunk.position();
                            complete = parser.parseNext(chunk);
                            if (chunk.position() == pos) {
                                if (!BufferUtil.isEmpty((ByteBuffer)chunk)) ** break;
                                continue block7;
                                var11_12 = null;
                                return var11_12;
                            }
                            bout.write(chunk.array(), chunk.arrayOffset() + pos, chunk.position() - pos);
                        } while (!complete);
                        break;
                    }
                    if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                        this._responseData = chunk;
                    }
                }
                if (bout.getCount() == 0 && this.isOutputShutdown()) {
                    var8_7 = null;
                    return var8_7;
                }
                var8_7 = ByteBuffer.wrap(bout.getBuf(), 0, bout.getCount());
                return var8_7;
            }
            finally {
                bout.close();
            }
        }
    }
}

