/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;

public abstract class DownloadFileInitializer
extends FileInitializer {
    private HttpClient httpClient;

    protected DownloadFileInitializer(BaseHome basehome, String ... scheme) {
        super(basehome, scheme);
    }

    protected abstract boolean allowInsecureHttpDownloads();

    protected void download(URI uri, Path destination) throws IOException {
        if ("http".equalsIgnoreCase(uri.getScheme()) && !this.allowInsecureHttpDownloads()) {
            throw new IOException("Insecure HTTP download not allowed (use --allow-insecure-http-downloads to bypass): " + String.valueOf(uri));
        }
        if (Files.exists(destination, new LinkOption[0])) {
            if (Files.isRegularFile(destination, new LinkOption[0])) {
                StartLog.warn("skipping download of %s : file exists in destination %s", uri, destination);
            } else {
                StartLog.warn("skipping download of %s : path conflict at destination %s", uri, destination);
            }
            return;
        }
        if (FS.ensureDirectoryExists(destination.getParent())) {
            StartLog.info("mkdir %s", this._basehome.toShortForm(destination.getParent()));
        }
        StartLog.info("download %s to %s", uri, this._basehome.toShortForm(destination));
        HttpClient httpClient = this.getHttpClient();
        try {
            Optional<String> location;
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            int status = response.statusCode();
            if (!this.allowInsecureHttpDownloads() && status >= 300 && status <= 399 && (location = response.headers().firstValue("Location")).isPresent()) {
                throw new IOException("URL GET Failure [status " + status + "] on " + String.valueOf(uri) + " wanting to redirect to insecure HTTP location (use --allow-insecure-http-downloads to bypass): " + location.get());
            }
            if (status != 200) {
                throw new IOException("URL GET Failure [status " + status + "] on " + String.valueOf(uri));
            }
            try (InputStream in = response.body();){
                Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to GET: " + String.valueOf(uri), e);
        }
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newBuilder().followRedirects(this.allowInsecureHttpDownloads() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NORMAL).proxy(ProxySelector.getDefault()).build();
        }
        return this.httpClient;
    }
}

