/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppClassLoader
extends URLClassLoader {
    private String _name;
    private WebAppContext _context;
    private ClassLoader _parent = this.getParent();
    private HashSet<String> _extensions;

    public WebAppClassLoader(WebAppContext context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, WebAppContext context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions = new HashSet();
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ContextHandler getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            URL url;
            Resource resource;
            block9: {
                File lib;
                File file;
                resource = this._context.newResource(tokenizer.nextToken());
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Path resource=" + resource));
                }
                if ((file = resource.getFile()) != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    continue;
                }
                if (resource.isDirectory() || file != null) break block9;
                InputStream in = resource.getInputStream();
                File tmp_dir = this._context.getTempDirectory();
                if (tmp_dir == null) {
                    tmp_dir = File.createTempFile("jetty.cl.lib", null);
                    tmp_dir.mkdir();
                    tmp_dir.deleteOnExit();
                }
                if (!(lib = new File(tmp_dir, "lib")).exists()) {
                    lib.mkdir();
                    lib.deleteOnExit();
                }
                File jar = File.createTempFile("Jetty-", ".jar", lib);
                jar.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Extract " + resource + " to " + jar));
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(jar);
                    IO.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IO.close(out);
                    throw throwable;
                }
                IO.close((OutputStream)out);
                URL url2 = jar.toURL();
                this.addURL(url2);
                continue;
            }
            url = resource.getURL();
            this.addURL(url);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (!this.isFileSupported(fnlc)) continue;
                    String jar = fn.toString();
                    jar = StringUtil.replace((String)jar, (String)",", (String)"%2C");
                    jar = StringUtil.replace((String)jar, (String)";", (String)"%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    Log.warn((String)"EXCEPTION ", (Throwable)ex);
                }
            }
        }
    }

    public void destroy() {
        this._parent = null;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public synchronized URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._context.isParentLoaderPriority() || this._context.isSystemClass(name)) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("HACK leading / off " + name));
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null && !tried_parent && !this._context.isServerClass(name) && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && Log.isDebugEnabled()) {
            Log.debug((String)("getResource(" + name + ")=" + url));
        }
        return url;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        if (system_class && server_class) {
            return null;
        }
        if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || system_class)) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent && !server_class) {
            c = this._parent.loadClass(name);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("loaded " + c + " from " + c.getClassLoader()));
        }
        return c;
    }

    public String toString() {
        if (Log.isDebugEnabled()) {
            return "ContextLoader@" + this._name + "(" + LazyList.array2List((Object[])this.getURLs()) + ") / " + this._parent;
        }
        return "ContextLoader@" + this._name;
    }
}

