/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.JarScanner;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class TagLibConfiguration
implements Configuration {
    public static final String __web_inf_pattern = "org.eclipse.jetty.webapp.WebInfIncludeTLDJarPattern";
    public static final String __container_pattern = "org.eclipse.jetty.server.webapp.ContainerIncludeTLDJarPattern";
    WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureWebApp() throws Exception {
        URL taglib21;
        URL taglib20;
        URL taglib12;
        URL taglib11;
        XmlParser parser;
        HashSet<Resource> tlds;
        block40: {
            block41: {
                String tmp;
                Resource web_inf;
                tlds = new HashSet<Resource>();
                if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
                    for (String location : this._context.getResourceAliases().values()) {
                        if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                        if (!location.startsWith("/")) {
                            location = "/WEB-INF/" + location;
                        }
                        Resource l = this._context.getBaseResource().addPath(location);
                        tlds.add(l);
                    }
                }
                if ((web_inf = this._context.getWebInf()) != null) {
                    String[] contents = web_inf.list();
                    for (int i = 0; contents != null && i < contents.length; ++i) {
                        if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                        Resource l = this._context.getWebInf().addPath(contents[i]);
                        tlds.add(l);
                    }
                }
                Pattern webInfPattern = (tmp = this._context.getInitParameter(__web_inf_pattern)) == null ? null : Pattern.compile(tmp);
                tmp = this._context.getInitParameter(__container_pattern);
                Pattern containerPattern = tmp == null ? null : Pattern.compile(tmp);
                TagLibJarScanner tldScanner = new TagLibJarScanner();
                try {
                    tldScanner.setTldSet(tlds);
                    tldScanner.scan(webInfPattern, Thread.currentThread().getContextClassLoader(), true, false);
                    tldScanner.scan(containerPattern, Thread.currentThread().getContextClassLoader().getParent(), false, true);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
                parser = new XmlParser(false);
                taglib11 = null;
                taglib12 = null;
                taglib20 = null;
                taglib21 = null;
                try {
                    Object var14_17;
                    try {
                        Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, (String)"javax.servlet.jsp.JspPage");
                        taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                        taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                        taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                        taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
                    }
                    catch (Exception e) {
                        Log.ignore((Throwable)e);
                        var14_17 = null;
                        if (taglib11 == null) {
                            taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                        }
                        if (taglib12 == null) {
                            taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                        }
                        if (taglib20 == null) {
                            taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                        }
                        if (taglib21 == null) {
                            taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                        }
                        break block40;
                    }
                    var14_17 = null;
                    if (taglib11 != null) break block41;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    if (taglib11 == null) {
                        taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                    }
                    if (taglib12 == null) {
                        taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                    }
                    if (taglib20 == null) {
                        taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                    }
                    if (taglib21 == null) {
                        taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                    }
                    throw throwable;
                }
                taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
            }
            if (taglib12 == null) {
                taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
            }
            if (taglib20 == null) {
                taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
            }
            if (taglib21 == null) {
                taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
            }
        }
        if (taglib11 != null) {
            parser.redirectEntity("web-jsptaglib_1_1.dtd", taglib11);
            parser.redirectEntity("web-jsptaglibrary_1_1.dtd", taglib11);
        }
        if (taglib12 != null) {
            parser.redirectEntity("web-jsptaglib_1_2.dtd", taglib12);
            parser.redirectEntity("web-jsptaglibrary_1_2.dtd", taglib12);
        }
        if (taglib20 != null) {
            parser.redirectEntity("web-jsptaglib_2_0.xsd", taglib20);
            parser.redirectEntity("web-jsptaglibrary_2_0.xsd", taglib20);
        }
        if (taglib21 != null) {
            parser.redirectEntity("web-jsptaglib_2_1.xsd", taglib21);
            parser.redirectEntity("web-jsptaglibrary_2_1.xsd", taglib21);
        }
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        block15: while (iter.hasNext()) {
            try {
                XmlParser.Node root;
                Resource tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("TLD=" + tld));
                }
                try {
                    root = parser.parse(tld.getInputStream());
                }
                catch (Exception e) {
                    root = parser.parse(tld.getURL().toString());
                }
                if (root == null) {
                    Log.warn((String)"No TLD root in {}", (Object)tld);
                    continue;
                }
                int i = 0;
                while (true) {
                    XmlParser.Node node;
                    if (i >= root.size()) continue block15;
                    Object o = root.get(i);
                    if (o instanceof XmlParser.Node && "listener".equals((node = (XmlParser.Node)o).getTag())) {
                        String className = node.getString("listener-class", false, true);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)("listener=" + className));
                        }
                        try {
                            Class listenerClass = this.getWebAppContext().loadClass(className);
                            EventListener l = (EventListener)listenerClass.newInstance();
                            this._context.addEventListener(l);
                        }
                        catch (Exception e) {
                            Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                            Log.debug((Throwable)e);
                        }
                        catch (Error e) {
                            Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                            Log.debug((Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void deconfigureWebApp() throws Exception {
    }

    public class TagLibJarScanner
    extends JarScanner {
        Set _tlds;

        public void setTldSet(Set tlds) {
            this._tlds = tlds;
        }

        public Set getTldSet() {
            return this._tlds;
        }

        public void processEntry(URL jarUrl, JarEntry entry) {
            try {
                String name = entry.getName();
                if (name.startsWith("META-INF/") && name.toLowerCase().endsWith(".tld")) {
                    Resource tld = TagLibConfiguration.this._context.newResource("jar:" + jarUrl + "!/" + name);
                    this._tlds.add(tld);
                    Log.debug((String)"TLD found {}", (Object)tld);
                }
            }
            catch (Exception e) {
                Log.warn((String)("Problem processing jar entry " + entry), (Throwable)e);
            }
        }
    }
}

