/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public abstract class JarScanner
extends PatternMatcher {
    public abstract void processEntry(URI var1, JarEntry var2);

    public void scan(Pattern pattern, URI[] uris, boolean isNullInclusive) throws Exception {
        super.match(pattern, uris, isNullInclusive);
    }

    public void scan(Pattern pattern, ClassLoader loader, boolean isNullInclusive, boolean visitParent) throws Exception {
        while (loader != null) {
            URL[] urls;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                URI[] uris = new URI[urls.length];
                int i = 0;
                for (URL u : urls) {
                    uris[i++] = u.toURI();
                }
                this.scan(pattern, uris, isNullInclusive);
            }
            if (visitParent) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matched(URI uri) throws Exception {
        Log.debug((String)"Search of {}", (Object)uri);
        if (uri.toString().toLowerCase().endsWith(".jar")) {
            InputStream in = Resource.newResource((URI)uri).getInputStream();
            if (in == null) {
                return;
            }
            JarInputStream jar_in = new JarInputStream(in);
            try {
                JarEntry entry = jar_in.getNextJarEntry();
                while (entry != null) {
                    this.processEntry(uri, entry);
                    entry = jar_in.getNextJarEntry();
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                jar_in.close();
                throw throwable;
            }
            jar_in.close();
            {
            }
        }
    }
}

