/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.codepoetics.protonpack.StreamUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscriptionManager;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientSessionManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<SessionActivityListener> listeners = Lists.newCopyOnWriteArrayList();
    private final AtomicReference<State> state = new AtomicReference<Inactive>(new Inactive());
    private final OpcUaClient client;

    ClientSessionManager(OpcUaClient client) {
        this.client = client;
        Predicate<StatusCode> sessionError = statusCode -> {
            long status = statusCode.getValue();
            return status == 2149974016L || status == 2149908480L || status == 2150039552L;
        };
        Predicate<StatusCode> secureChannelError = statusCode -> {
            long status = statusCode.getValue();
            return status == 0x80220000L || status == 2148728832L || status == 2155806720L;
        };
        client.addFaultListener(serviceFault -> {
            StatusCode serviceResult = serviceFault.getResponseHeader().getServiceResult();
            if (sessionError.or(secureChannelError).test(serviceResult)) {
                Creating creating;
                this.logger.debug("ServiceFault: {}", (Object)serviceResult);
                State currentState = this.state.get();
                if (currentState instanceof Active && this.state.compareAndSet(currentState, creating = new Creating())) {
                    OpcUaSession session = ((Active)currentState).session;
                    this.notifySessionInactive(session);
                    client.getStackClient().disconnect().whenCompleteAsync((v, ex) -> this.createSession(creating));
                }
            }
        });
    }

    void addListener(SessionActivityListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(SessionActivityListener listener) {
        this.listeners.remove(listener);
    }

    CompletableFuture<OpcUaSession> getSession() {
        State currentState = this.state.get();
        this.logger.trace("getSession(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof Inactive) {
            Creating creatingState = new Creating();
            if (this.state.compareAndSet(currentState, creatingState)) {
                CompletableFuture<OpcUaSession> sessionFuture = creatingState.sessionFuture;
                this.createSession(creatingState);
                return sessionFuture;
            }
            return this.getSession();
        }
        if (currentState instanceof Creating) {
            return ((Creating)currentState).sessionFuture;
        }
        if (currentState instanceof Activating) {
            return ((Activating)currentState).sessionFuture;
        }
        if (currentState instanceof Transferring) {
            return ((Transferring)currentState).sessionFuture;
        }
        if (currentState instanceof Active) {
            return ((Active)currentState).sessionFuture;
        }
        if (currentState instanceof Reactivating) {
            return ((Reactivating)currentState).sessionFuture;
        }
        if (currentState instanceof Closing) {
            CompletableFuture<OpcUaSession> future = new CompletableFuture<OpcUaSession>();
            ((Closing)currentState).closeFuture.whenCompleteAsync((oldSession, ex) -> this.getSession().whenComplete((session, ex2) -> {
                if (session != null) {
                    future.complete((OpcUaSession)session);
                } else {
                    future.completeExceptionally((Throwable)ex2);
                }
            }));
            return future;
        }
        throw new IllegalStateException("unexpected state: " + currentState.getClass());
    }

    CompletableFuture<Unit> closeSession() {
        State currentState = this.state.get();
        this.logger.trace("closeSession(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof Inactive) {
            return CompletableFuture.completedFuture(Unit.VALUE);
        }
        if (currentState instanceof Closing) {
            return ((CompletableFuture)((Closing)currentState).closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
        }
        if (currentState instanceof Creating) {
            Closing closingState = new Closing();
            if (this.state.compareAndSet(currentState, closingState)) {
                this.closeSession(closingState, ((Creating)currentState).sessionFuture);
                return ((CompletableFuture)closingState.closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
            }
            return this.closeSession();
        }
        if (currentState instanceof Activating) {
            Closing closingState = new Closing();
            if (this.state.compareAndSet(currentState, closingState)) {
                this.closeSession(closingState, ((Activating)currentState).sessionFuture);
                return ((CompletableFuture)closingState.closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
            }
            return this.closeSession();
        }
        if (currentState instanceof Reactivating) {
            Closing closingState = new Closing();
            if (this.state.compareAndSet(currentState, closingState)) {
                this.closeSession(closingState, ((Reactivating)currentState).sessionFuture);
                return ((CompletableFuture)closingState.closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
            }
            return this.closeSession();
        }
        if (currentState instanceof Transferring) {
            Closing closingState = new Closing();
            if (this.state.compareAndSet(currentState, closingState)) {
                this.closeSession(closingState, ((Transferring)currentState).sessionFuture);
                return ((CompletableFuture)closingState.closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
            }
            return this.closeSession();
        }
        if (currentState instanceof Active) {
            Closing closingState = new Closing();
            if (this.state.compareAndSet(currentState, closingState)) {
                this.closeSession(closingState, ((Active)currentState).sessionFuture);
                return ((CompletableFuture)closingState.closeFuture.thenApply(s -> Unit.VALUE)).exceptionally(ex -> Unit.VALUE);
            }
            return this.closeSession();
        }
        throw new IllegalStateException("unexpected state: " + currentState.getClass());
    }

    private void closeSession(Closing closingState, CompletableFuture<OpcUaSession> sessionFuture) {
        sessionFuture.whenComplete((session, ex) -> {
            if (session != null) {
                UaTcpStackClient stackClient = this.client.getStackClient();
                RequestHeader requestHeader = new RequestHeader(session.getAuthenticationToken(), DateTime.now(), this.client.nextRequestHandle(), Unsigned.uint((int)0), null, Unsigned.uint((int)5000), null);
                CloseSessionRequest request = new CloseSessionRequest(requestHeader, Boolean.valueOf(true));
                this.logger.debug("Sending CloseSessionRequest...");
                stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((csr, ex2) -> {
                    if (ex2 != null) {
                        this.logger.debug("CloseSession failed: {}", (Object)ex2.getMessage(), ex2);
                    } else {
                        this.logger.debug("Session closed: {}", (Object)session.getSessionId());
                    }
                    this.state.compareAndSet(closingState, new Inactive());
                    closingState.closeFuture.complete((OpcUaSession)session);
                });
            } else {
                this.state.compareAndSet(closingState, new Inactive());
                closingState.closeFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    private void notifySessionActive(OpcUaSession session) {
        this.listeners.forEach(listener -> {
            try {
                listener.onSessionActive(session);
            }
            catch (Throwable t) {
                this.logger.warn("Uncaught Throwable notifying listener: {}", listener, (Object)t);
            }
        });
    }

    private void notifySessionInactive(OpcUaSession session) {
        this.listeners.forEach(listener -> {
            try {
                listener.onSessionInactive(session);
            }
            catch (Throwable t) {
                this.logger.warn("Uncaught Throwable notifying listener: {}", listener, (Object)t);
            }
        });
    }

    private void createSession(Creating creatingState) {
        UaTcpStackClient stackClient = this.client.getStackClient();
        String serverUri = stackClient.getEndpoint().flatMap(e -> {
            String gatewayServerUri = e.getServer().getGatewayServerUri();
            if (gatewayServerUri != null && !gatewayServerUri.isEmpty()) {
                return Optional.ofNullable(e.getServer().getApplicationUri());
            }
            return Optional.empty();
        }).orElse(null);
        ByteString clientNonce = NonceUtil.generateNonce((int)32);
        ByteString clientCertificate = stackClient.getConfig().getCertificate().map(c -> {
            try {
                return ByteString.of((byte[])c.getEncoded());
            }
            catch (CertificateEncodingException e) {
                return ByteString.NULL_VALUE;
            }
        }).orElse(ByteString.NULL_VALUE);
        CreateSessionRequest request = new CreateSessionRequest(this.client.newRequestHeader(), stackClient.getApplication(), serverUri, stackClient.getEndpointUrl(), this.client.getConfig().getSessionName().get(), clientNonce, clientCertificate, Double.valueOf(this.client.getConfig().getSessionTimeout().doubleValue()), this.client.getConfig().getMaxResponseMessageSize());
        this.logger.debug("Sending CreateSessionRequest...");
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((csr, ex) -> {
            CompletableFuture<OpcUaSession> sessionFuture = creatingState.sessionFuture;
            if (csr != null) {
                this.logger.debug("Session created: {}", (Object)csr.getSessionId());
                Activating activatingState = new Activating(sessionFuture);
                if (this.state.compareAndSet(creatingState, activatingState)) {
                    this.activateSession(activatingState, (CreateSessionResponse)csr);
                }
            } else {
                this.logger.debug("CreateSession failed: {}", (Object)ex.getMessage(), ex);
                this.state.compareAndSet(creatingState, new Inactive());
                sessionFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    private void activateSession(Activating activatingState, CreateSessionResponse csr) {
        UaTcpStackClient stackClient = this.client.getStackClient();
        Function<ClientSecureChannel, CompletableFuture> activate = secureChannel -> {
            try {
                Channel channel = secureChannel.getChannel();
                if (channel.pipeline().get(InactivityHandler.class) == null) {
                    channel.pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                }
                EndpointDescription endpoint = (EndpointDescription)stackClient.getEndpoint().orElseThrow(() -> new Exception("cannot create session with no endpoint configured"));
                Tuple2<UserIdentityToken, SignatureData> tuple = this.client.getConfig().getIdentityProvider().getIdentityToken(endpoint, csr.getServerNonce());
                UserIdentityToken userIdentityToken = (UserIdentityToken)tuple.v1();
                SignatureData userTokenSignature = (SignatureData)tuple.v2();
                ActivateSessionRequest request = new ActivateSessionRequest(this.client.newRequestHeader(csr.getAuthenticationToken()), this.buildClientSignature((ClientSecureChannel)secureChannel, csr), new SignedSoftwareCertificate[0], new String[0], ExtensionObject.encode((UaStructure)userIdentityToken), userTokenSignature);
                this.logger.debug("Sending ActivateSessionRequest, secureChannelId={}, channel={}...", (Object)secureChannel.getChannelId(), (Object)secureChannel.getChannel());
                return stackClient.sendRequest((UaRequestMessage)request);
            }
            catch (Exception e) {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(e);
                return f;
            }
        };
        ((CompletableFuture)stackClient.getChannelFuture().thenCompose(activate)).whenCompleteAsync((asr, ex) -> {
            CompletableFuture<OpcUaSession> sessionFuture = activatingState.sessionFuture;
            if (asr != null) {
                this.logger.debug("Session activated: {}", (Object)csr.getSessionId());
                OpcUaSession session = new OpcUaSession(csr.getAuthenticationToken(), csr.getSessionId(), this.client.getConfig().getSessionName().get(), csr.getRevisedSessionTimeout(), csr.getMaxRequestMessageSize(), csr.getServerCertificate(), csr.getServerSoftwareCertificates());
                session.setServerNonce(asr.getServerNonce());
                OpcUaSubscriptionManager subscriptionManager = this.client.getSubscriptionManager();
                int subscriptionCount = subscriptionManager.getSubscriptions().size();
                boolean transferNeeded = subscriptionCount > 0;
                this.logger.debug("subscriptionCount={}, transferNeeded={}", (Object)subscriptionCount, (Object)transferNeeded);
                if (transferNeeded) {
                    Transferring transferringState = new Transferring(sessionFuture);
                    if (this.state.compareAndSet(activatingState, transferringState)) {
                        this.transferSubscriptions(transferringState, session);
                    }
                } else {
                    this.state.compareAndSet(activatingState, new Active(session, sessionFuture));
                    sessionFuture.complete(session);
                }
            } else {
                this.logger.debug("ActivateSession failed: {}", (Object)ex.getMessage(), ex);
                this.state.compareAndSet(activatingState, new Inactive());
                sessionFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    private void reactivateSession(Reactivating reactivatingState, OpcUaSession previousSession) {
        UaTcpStackClient stackClient = this.client.getStackClient();
        Function<ClientSecureChannel, CompletionStage> activate = secureChannel -> {
            try {
                Channel channel = secureChannel.getChannel();
                if (channel.pipeline().get(InactivityHandler.class) == null) {
                    channel.pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                }
                EndpointDescription endpoint = (EndpointDescription)stackClient.getEndpoint().orElseThrow(() -> new Exception("cannot create session with no endpoint configured"));
                Tuple2<UserIdentityToken, SignatureData> tuple = this.client.getConfig().getIdentityProvider().getIdentityToken(endpoint, previousSession.getServerNonce());
                UserIdentityToken userIdentityToken = (UserIdentityToken)tuple.v1();
                SignatureData userTokenSignature = (SignatureData)tuple.v2();
                SignatureData clientSignature = this.buildClientSignature((ClientSecureChannel)secureChannel, previousSession.getServerCertificate(), previousSession.getServerNonce());
                ActivateSessionRequest request = new ActivateSessionRequest(this.client.newRequestHeader(previousSession.getAuthenticationToken()), clientSignature, new SignedSoftwareCertificate[0], new String[0], ExtensionObject.encode((UaStructure)userIdentityToken), userTokenSignature);
                this.logger.debug("Sending (re)ActivateSessionRequest, secureChannelId={}, channel={}...", (Object)secureChannel.getChannelId(), (Object)secureChannel.getChannel());
                return stackClient.sendRequest((UaRequestMessage)request);
            }
            catch (Exception e) {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(e);
                return f;
            }
        };
        ((CompletableFuture)stackClient.getChannelFuture().thenCompose(activate)).whenCompleteAsync((asr, ex) -> {
            CompletableFuture<OpcUaSession> sessionFuture = reactivatingState.sessionFuture;
            if (asr != null) {
                this.logger.debug("Session reactivated: {}", (Object)previousSession.getSessionId());
                OpcUaSession newSession = new OpcUaSession(previousSession.getAuthenticationToken(), previousSession.getSessionId(), this.client.getConfig().getSessionName().get(), previousSession.getSessionTimeout(), previousSession.getMaxRequestSize(), previousSession.getServerCertificate(), previousSession.getServerSoftwareCertificates());
                newSession.setServerNonce(asr.getServerNonce());
                this.state.compareAndSet(reactivatingState, new Active(newSession, sessionFuture));
                sessionFuture.complete(newSession);
            } else {
                this.logger.debug("(re)ActivateSession failed: {}", (Object)ex.getMessage(), ex);
                StatusCode statusCode = UaException.extract((Throwable)ex).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                if (statusCode.getValue() == 2149974016L || statusCode.getValue() == 2149908480L || statusCode.getValue() == 2150039552L || statusCode.getValue() == 2148728832L) {
                    Creating creating = new Creating(sessionFuture);
                    if (this.state.compareAndSet(reactivatingState, creating)) {
                        this.createSession(creating);
                    } else {
                        sessionFuture.completeExceptionally((Throwable)ex);
                    }
                } else {
                    Reactivating reactivatingAgain = new Reactivating();
                    if (this.state.compareAndSet(reactivatingState, reactivatingAgain)) {
                        this.reactivateSession(reactivatingAgain, previousSession);
                    }
                    sessionFuture.completeExceptionally((Throwable)ex);
                }
            }
        });
    }

    private void transferSubscriptions(Transferring transferringState, OpcUaSession session) {
        UaTcpStackClient stackClient = this.client.getStackClient();
        OpcUaSubscriptionManager subscriptionManager = this.client.getSubscriptionManager();
        ImmutableList<UaSubscription> subscriptions = subscriptionManager.getSubscriptions();
        UInteger[] subscriptionIdsArray = (UInteger[])subscriptions.stream().map(UaSubscription::getSubscriptionId).toArray(UInteger[]::new);
        TransferSubscriptionsRequest request = new TransferSubscriptionsRequest(this.client.newRequestHeader(session.getAuthenticationToken()), subscriptionIdsArray, Boolean.valueOf(true));
        this.logger.debug("Sending TransferSubscriptionsRequest...");
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((tsr, ex) -> {
            CompletableFuture<OpcUaSession> sessionFuture = transferringState.sessionFuture;
            if (tsr != null) {
                List results = ConversionUtil.l((Object[])tsr.getResults());
                for (int i2 = 0; i2 < results.size(); ++i2) {
                    TransferResult result = (TransferResult)results.get(i2);
                    if (result.getStatusCode().isGood()) continue;
                    UaSubscription subscription = (UaSubscription)subscriptions.get(i2);
                    subscriptionManager.transferFailed(subscription.getSubscriptionId(), result.getStatusCode());
                }
                if (this.logger.isDebugEnabled()) {
                    Stream<UInteger> subscriptionIds = subscriptions.stream().map(UaSubscription::getSubscriptionId);
                    Stream<StatusCode> statusCodes = results.stream().map(TransferResult::getStatusCode);
                    Object[] ss = (String[])StreamUtils.zip(subscriptionIds, statusCodes, (i, s) -> String.format("id=%s/%s", i, StatusCodes.lookup((long)s.getValue()).map(sa -> sa[0]).orElse(s.toString()))).toArray(String[]::new);
                    this.logger.debug("TransferSubscriptions results: {}", (Object)Arrays.toString(ss));
                }
                this.state.compareAndSet(transferringState, new Active(session, sessionFuture));
                sessionFuture.complete(session);
            } else {
                StatusCode statusCode = UaException.extract((Throwable)ex).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                if (statusCode.getValue() == 0x80400000L || statusCode.getValue() == 2151481344L || statusCode.getValue() == 0x808D0000L || statusCode.getValue() == 0x800B0000L) {
                    this.logger.debug("TransferSubscriptions not supported: {}", (Object)statusCode);
                    for (UaSubscription subscription : subscriptions) {
                        subscriptionManager.transferFailed(subscription.getSubscriptionId(), statusCode);
                    }
                    this.state.compareAndSet(transferringState, new Active(session, sessionFuture));
                    sessionFuture.complete(session);
                } else {
                    this.logger.debug("TransferSubscriptions failed: {}", (Object)statusCode);
                    Closing closing = new Closing();
                    if (this.state.compareAndSet(transferringState, closing)) {
                        this.closeSession(closing, CompletableFuture.completedFuture(session));
                        closing.closeFuture.whenComplete((v, ex2) -> sessionFuture.completeExceptionally((Throwable)ex));
                    }
                }
            }
        });
    }

    private SignatureData buildClientSignature(ClientSecureChannel secureChannel, CreateSessionResponse response) {
        ByteString serverCert = response.getServerCertificate() != null ? response.getServerCertificate() : ByteString.NULL_VALUE;
        ByteString serverNonce = response.getServerNonce() != null ? response.getServerNonce() : ByteString.NULL_VALUE;
        return this.buildClientSignature(secureChannel, serverCert, serverNonce);
    }

    private SignatureData buildClientSignature(ClientSecureChannel secureChannel, ByteString serverCertificate, ByteString serverNonce) {
        byte[] serverNonceBytes = Optional.ofNullable(serverNonce.bytes()).orElse(new byte[0]);
        byte[] serverCertificateBytes = Optional.ofNullable(serverCertificate.bytes()).orElse(new byte[0]);
        byte[] signature = new byte[serverCertificateBytes.length + serverNonceBytes.length];
        System.arraycopy(serverCertificateBytes, 0, signature, 0, serverCertificateBytes.length);
        System.arraycopy(serverNonceBytes, 0, signature, serverCertificateBytes.length, serverNonceBytes.length);
        SecurityAlgorithm signatureAlgorithm = secureChannel.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        if (secureChannel.getSecurityPolicy() == SecurityPolicy.None) {
            return new SignatureData();
        }
        try {
            PrivateKey privateKey = secureChannel.getKeyPair().getPrivate();
            signature = SignatureUtil.sign((SecurityAlgorithm)signatureAlgorithm, (PrivateKey)privateKey, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(signature)});
        }
        catch (Throwable t) {
            this.logger.warn("Asymmetric signing failed: {}", (Object)t.getMessage(), (Object)t);
        }
        return new SignatureData(signatureAlgorithm.getUri(), ByteString.of((byte[])signature));
    }

    private class Closing
    implements State {
        final CompletableFuture<OpcUaSession> closeFuture = new CompletableFuture();

        Closing() {
            this.closeFuture.thenAccept(x$0 -> ClientSessionManager.this.notifySessionInactive(x$0));
        }
    }

    private class Reactivating
    implements State {
        final CompletableFuture<OpcUaSession> sessionFuture = new CompletableFuture();

        Reactivating() {
            this.sessionFuture.thenAccept(session -> {
                ClientSessionManager.this.client.getSubscriptionManager().startPublishing();
                ClientSessionManager.this.notifySessionActive(session);
            });
        }
    }

    private static class Active
    implements State {
        final OpcUaSession session;
        final CompletableFuture<OpcUaSession> sessionFuture;

        Active(OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
            this.session = session;
            this.sessionFuture = sessionFuture;
        }
    }

    private static class Transferring
    implements State {
        final CompletableFuture<OpcUaSession> sessionFuture;

        Transferring(CompletableFuture<OpcUaSession> sessionFuture) {
            this.sessionFuture = sessionFuture;
        }
    }

    private static class Activating
    implements State {
        final CompletableFuture<OpcUaSession> sessionFuture;

        Activating(CompletableFuture<OpcUaSession> sessionFuture) {
            this.sessionFuture = sessionFuture;
        }
    }

    private class Creating
    implements State {
        final CompletableFuture<OpcUaSession> sessionFuture;

        Creating() {
            this.sessionFuture = new CompletableFuture();
            this.sessionFuture.thenAccept(session -> {
                ClientSessionManager.this.client.getSubscriptionManager().startPublishing();
                ClientSessionManager.this.notifySessionActive(session);
            });
        }

        Creating(CompletableFuture<OpcUaSession> sessionFuture) {
            this.sessionFuture = sessionFuture;
        }
    }

    private static class Inactive
    implements State {
        private Inactive() {
        }
    }

    private static interface State {
    }

    private class InactivityHandler
    extends ChannelInboundHandlerAdapter {
        private InactivityHandler() {
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            State currentState = (State)ClientSessionManager.this.state.get();
            ClientSessionManager.this.logger.debug("channelInactive(), currentState={}", (Object)currentState.getClass().getSimpleName());
            if (currentState instanceof Active) {
                Reactivating reactivating = new Reactivating();
                if (ClientSessionManager.this.state.compareAndSet(currentState, reactivating)) {
                    OpcUaSession session = ((Active)currentState).session;
                    ClientSessionManager.this.notifySessionInactive(session);
                    ClientSessionManager.this.reactivateSession(reactivating, session);
                }
            }
            super.channelInactive(ctx);
        }
    }
}

