/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AcknowledgeableConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class AcknowledgeableConditionNode
extends ConditionNode
implements AcknowledgeableConditionType {
    public AcknowledgeableConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> enabledState() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:EnabledState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.enabledState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AcknowledgeableConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.enabledState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> ackedState() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:AckedState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getAckedState() {
        return ((CompletableFuture)this.ackedState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AcknowledgeableConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setAckedState(LocalizedText value) {
        return this.ackedState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> confirmedState() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:ConfirmedState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getConfirmedState() {
        return ((CompletableFuture)this.confirmedState().thenCompose(UaVariableNode::getValue)).thenApply(o -> AcknowledgeableConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setConfirmedState(LocalizedText value) {
        return this.confirmedState().thenCompose(node -> node.setValue(value));
    }
}

