/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.StateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TransitionVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.TransitionEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class TransitionEventNode
extends BaseEventNode
implements TransitionEventType {
    public TransitionEventNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<TransitionVariableNode> transition() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:Transition")).thenApply(TransitionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getTransition() {
        return ((CompletableFuture)this.transition().thenCompose(UaVariableNode::getValue)).thenApply(o -> TransitionEventNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setTransition(LocalizedText value) {
        return this.transition().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<StateVariableNode> fromState() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:FromState")).thenApply(StateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getFromState() {
        return ((CompletableFuture)this.fromState().thenCompose(UaVariableNode::getValue)).thenApply(o -> TransitionEventNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setFromState(LocalizedText value) {
        return this.fromState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<StateVariableNode> toState() {
        return this.getVariableComponent(QualifiedName.parse((String)"0:ToState")).thenApply(StateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getToState() {
        return ((CompletableFuture)this.toState().thenCompose(UaVariableNode::getValue)).thenApply(o -> TransitionEventNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setToState(LocalizedText value) {
        return this.toState().thenCompose(node -> node.setValue(value));
    }
}

