/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.identity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernameProvider
implements IdentityProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String username;
    private final String password;
    private final Function<List<UserTokenPolicy>, UserTokenPolicy> policyChooser;

    public UsernameProvider(String username, String password) {
        this(username, password, ps -> (UserTokenPolicy)ps.get(0));
    }

    public UsernameProvider(String username, String password, Function<List<UserTokenPolicy>, UserTokenPolicy> policyChooser) {
        this.username = username;
        this.password = password;
        this.policyChooser = policyChooser;
    }

    @Override
    public Tuple2<UserIdentityToken, SignatureData> getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        Object bs;
        List userIdentityTokens = ConversionUtil.l((Object[])endpoint.getUserIdentityTokens());
        List tokenPolicies = userIdentityTokens.stream().filter(t -> t.getTokenType() == UserTokenType.UserName).collect(Collectors.toList());
        if (tokenPolicies.isEmpty()) {
            throw new Exception("no UserTokenPolicy with UserTokenType.UserName found");
        }
        UserTokenPolicy tokenPolicy = this.policyChooser.apply(tokenPolicies);
        String policyId = tokenPolicy.getPolicyId();
        SecurityPolicy securityPolicy = SecurityPolicy.None;
        String securityPolicyUri = tokenPolicy.getSecurityPolicyUri();
        try {
            if (securityPolicyUri != null && !securityPolicyUri.isEmpty()) {
                securityPolicy = SecurityPolicy.fromUri((String)securityPolicyUri);
            } else {
                securityPolicyUri = endpoint.getSecurityPolicyUri();
                securityPolicy = SecurityPolicy.fromUri((String)securityPolicyUri);
            }
        }
        catch (Throwable t2) {
            this.logger.warn("Error parsing SecurityPolicy for uri={}, falling back to no security.", (Object)securityPolicyUri);
        }
        byte[] passwordBytes = this.password.getBytes("UTF-8");
        byte[] nonceBytes = Optional.ofNullable(serverNonce.bytes()).orElse(new byte[0]);
        ByteBuf buffer = Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN);
        if (securityPolicy == SecurityPolicy.None) {
            buffer.writeBytes(passwordBytes);
        } else {
            buffer.writeInt(passwordBytes.length + nonceBytes.length);
            buffer.writeBytes(passwordBytes);
            buffer.writeBytes(nonceBytes);
            bs = endpoint.getServerCertificate();
            if (bs == null || bs.isNull()) {
                throw new UaException(0x80890000L, "UserTokenPolicy requires encryption but server did not provide a certificate in endpoint");
            }
            X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])bs.bytes());
            int plainTextBlockSize = SecureChannel.getAsymmetricPlainTextBlockSize((X509Certificate)certificate, (SecurityAlgorithm)securityPolicy.getAsymmetricEncryptionAlgorithm());
            int cipherTextBlockSize = SecureChannel.getAsymmetricCipherTextBlockSize((Certificate)certificate, (SecurityAlgorithm)securityPolicy.getAsymmetricEncryptionAlgorithm());
            int blockCount = (buffer.readableBytes() + plainTextBlockSize - 1) / plainTextBlockSize;
            Cipher cipher = this.getAndInitializeCipher(certificate, securityPolicy);
            ByteBuffer plainTextNioBuffer = buffer.nioBuffer();
            ByteBuffer cipherTextNioBuffer = Unpooled.buffer((int)(cipherTextBlockSize * blockCount)).order(ByteOrder.LITTLE_ENDIAN).nioBuffer(0, cipherTextBlockSize * blockCount);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                int position = blockNumber * plainTextBlockSize;
                int limit = Math.min(buffer.readableBytes(), (blockNumber + 1) * plainTextBlockSize);
                plainTextNioBuffer.position(position).limit(limit);
                cipher.doFinal(plainTextNioBuffer, cipherTextNioBuffer);
            }
            cipherTextNioBuffer.flip();
            buffer = Unpooled.wrappedBuffer((ByteBuffer)cipherTextNioBuffer);
        }
        bs = new byte[buffer.readableBytes()];
        buffer.readBytes(bs);
        String securityAlgorithmUri = securityPolicy.getAsymmetricEncryptionAlgorithm().getUri();
        String encryptionAlgorithm = securityAlgorithmUri.isEmpty() ? null : securityAlgorithmUri;
        UserNameIdentityToken token = new UserNameIdentityToken(policyId, this.username, ByteString.of((byte[])bs), encryptionAlgorithm);
        return new Tuple2((Object)token, (Object)new SignatureData());
    }

    private Cipher getAndInitializeCipher(X509Certificate serverCertificate, SecurityPolicy securityPolicy) throws UaException {
        assert (serverCertificate != null);
        try {
            String transformation = securityPolicy.getAsymmetricEncryptionAlgorithm().getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, serverCertificate.getPublicKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }

    public String toString() {
        return "UsernameProvider{username='" + this.username + '\'' + '}';
    }

    public static UsernameProvider of(String username, String password) {
        return new UsernameProvider(username, password);
    }
}

