/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Active;
import org.eclipse.milo.opcua.sdk.client.session.states.Closing;
import org.eclipse.milo.opcua.sdk.client.session.states.Recreating;
import org.eclipse.milo.opcua.sdk.client.session.states.Retransferring;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class Reactivating
extends AbstractSessionState
implements SessionState {
    private CompletableFuture<OpcUaSession> sessionFuture = new CompletableFuture();

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onExternalTransition(Fsm fsm, SessionState prev, Event event) {
        if (prev instanceof Recreating && event instanceof CreateSessionSuccessEvent) {
            this.sessionFuture = ((CreateSessionSuccessEvent)event).getSessionFuture();
        }
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            FutureUtils.complete(e.getSessionFuture()).with(this.sessionFuture);
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event event) {
        if (event instanceof ReactivateSuccessEvent) {
            OpcUaSession session = ((ReactivateSuccessEvent)event).getSession();
            this.sessionFuture.complete(session);
            return new Active();
        }
        if (event instanceof ReactivateFailureEvent) {
            ReactivateFailureEvent e = (ReactivateFailureEvent)event;
            StatusCode statusCode = UaException.extract((Throwable)e.getFailure()).map(UaException::getStatusCode).orElse(StatusCode.BAD);
            this.sessionFuture.completeExceptionally(new UaException(statusCode));
            if (statusCode.getValue() == 0x800A0000L || statusCode.getValue() == 2158755840L) {
                Reactivating reactivating = new Reactivating();
                Reactivating.reactivateSessionAsync(fsm, e.getSession(), reactivating.getSessionFuture());
                return reactivating;
            }
            Recreating recreating = new Recreating();
            Reactivating.createSessionAsync(fsm, recreating.getSessionFuture());
            return recreating;
        }
        if (event instanceof ActivateSessionSuccessEvent) {
            OpcUaSession session = ((ActivateSessionSuccessEvent)event).getSession();
            Reactivating.transferSubscriptionsAsync(fsm, session, this.sessionFuture);
            return new Retransferring();
        }
        if (event instanceof ActivateSessionFailureEvent) {
            Throwable failure = ((ActivateSessionFailureEvent)event).getFailure();
            this.sessionFuture.completeExceptionally(failure);
            Recreating recreating = new Recreating();
            Reactivating.createSessionAsync(fsm, recreating.getSessionFuture());
            return recreating;
        }
        if (event instanceof CloseSessionEvent) {
            return new Closing();
        }
        return this;
    }
}

