/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.DialogConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class DialogConditionNode
extends ConditionNode
implements DialogConditionType {
    public DialogConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> getPromptNode() {
        return this.getPropertyNode(DialogConditionType.PROMPT);
    }

    @Override
    public CompletableFuture<LocalizedText> getPrompt() {
        return this.getProperty(DialogConditionType.PROMPT);
    }

    @Override
    public CompletableFuture<StatusCode> setPrompt(LocalizedText value) {
        return this.setProperty(DialogConditionType.PROMPT, value);
    }

    public CompletableFuture<PropertyNode> getResponseOptionSetNode() {
        return this.getPropertyNode(DialogConditionType.RESPONSE_OPTION_SET);
    }

    @Override
    public CompletableFuture<LocalizedText[]> getResponseOptionSet() {
        return this.getProperty(DialogConditionType.RESPONSE_OPTION_SET);
    }

    @Override
    public CompletableFuture<StatusCode> setResponseOptionSet(LocalizedText[] value) {
        return this.setProperty(DialogConditionType.RESPONSE_OPTION_SET, value);
    }

    public CompletableFuture<PropertyNode> getDefaultResponseNode() {
        return this.getPropertyNode(DialogConditionType.DEFAULT_RESPONSE);
    }

    @Override
    public CompletableFuture<Integer> getDefaultResponse() {
        return this.getProperty(DialogConditionType.DEFAULT_RESPONSE);
    }

    @Override
    public CompletableFuture<StatusCode> setDefaultResponse(Integer value) {
        return this.setProperty(DialogConditionType.DEFAULT_RESPONSE, value);
    }

    public CompletableFuture<PropertyNode> getOkResponseNode() {
        return this.getPropertyNode(DialogConditionType.OK_RESPONSE);
    }

    @Override
    public CompletableFuture<Integer> getOkResponse() {
        return this.getProperty(DialogConditionType.OK_RESPONSE);
    }

    @Override
    public CompletableFuture<StatusCode> setOkResponse(Integer value) {
        return this.setProperty(DialogConditionType.OK_RESPONSE, value);
    }

    public CompletableFuture<PropertyNode> getCancelResponseNode() {
        return this.getPropertyNode(DialogConditionType.CANCEL_RESPONSE);
    }

    @Override
    public CompletableFuture<Integer> getCancelResponse() {
        return this.getProperty(DialogConditionType.CANCEL_RESPONSE);
    }

    @Override
    public CompletableFuture<StatusCode> setCancelResponse(Integer value) {
        return this.setProperty(DialogConditionType.CANCEL_RESPONSE, value);
    }

    public CompletableFuture<PropertyNode> getLastResponseNode() {
        return this.getPropertyNode(DialogConditionType.LAST_RESPONSE);
    }

    @Override
    public CompletableFuture<Integer> getLastResponse() {
        return this.getProperty(DialogConditionType.LAST_RESPONSE);
    }

    @Override
    public CompletableFuture<StatusCode> setLastResponse(Integer value) {
        return this.setProperty(DialogConditionType.LAST_RESPONSE, value);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> getEnabledStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.getEnabledStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.getEnabledStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> getDialogStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "DialogState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getDialogState() {
        return ((CompletableFuture)this.getDialogStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setDialogState(LocalizedText value) {
        return this.getDialogStateNode().thenCompose(node -> node.setValue(value));
    }
}

