/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;

public class UaViewNode
extends UaNode
implements ViewNode {
    public UaViewNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<Boolean> getContainsNoLoops() {
        return this.getAttributeOrFail(this.readContainsNoLoops());
    }

    @Override
    public CompletableFuture<UByte> getEventNotifier() {
        return this.getAttributeOrFail(this.readEventNotifier());
    }

    @Override
    public CompletableFuture<StatusCode> setContainsNoLoops(boolean containsNoLoops) {
        return this.writeContainsNoLoops(DataValue.valueOnly((Variant)new Variant((Object)containsNoLoops)));
    }

    @Override
    public CompletableFuture<StatusCode> setEventNotifier(UByte eventNotifier) {
        return this.writeEventNotifier(DataValue.valueOnly((Variant)new Variant((Object)eventNotifier)));
    }

    @Override
    public CompletableFuture<DataValue> readContainsNoLoops() {
        return this.readAttribute(AttributeId.ContainsNoLoops);
    }

    @Override
    public CompletableFuture<DataValue> readEventNotifier() {
        return this.readAttribute(AttributeId.EventNotifier);
    }

    @Override
    public CompletableFuture<StatusCode> writeContainsNoLoops(DataValue value) {
        return this.writeAttribute(AttributeId.ContainsNoLoops, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeEventNotifier(DataValue value) {
        return this.writeAttribute(AttributeId.EventNotifier, value);
    }
}

