/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class ObjectTypeManager {
    private final ConcurrentMap<NodeId, ObjectTypeDefinition> typeDefinitions = Maps.newConcurrentMap();

    public void registerObjectType(NodeId typeDefinition, Class<? extends UaObjectNode> nodeClass, ObjectNodeConstructor objectNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new ObjectTypeDefinition(nodeClass, objectNodeConstructor));
    }

    public Optional<ObjectNodeConstructor> getNodeFactory(NodeId typeDefinition) {
        ObjectTypeDefinition def = (ObjectTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeFactory);
    }

    @FunctionalInterface
    public static interface ObjectNodeConstructor {
        public UaObjectNode apply(OpcUaClient var1, NodeId var2);
    }

    private static class ObjectTypeDefinition {
        final Class<? extends UaNode> nodeClass;
        final ObjectNodeConstructor nodeFactory;

        private ObjectTypeDefinition(Class<? extends UaNode> nodeClass, ObjectNodeConstructor nodeFactory) {
            this.nodeClass = nodeClass;
            this.nodeFactory = nodeFactory;
        }
    }
}

