/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ConditionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class ConditionTypeNode
extends BaseEventTypeNode
implements ConditionType {
    public ConditionTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getConditionClassIdNode() {
        return this.getPropertyNode(ConditionType.CONDITION_CLASS_ID);
    }

    @Override
    public CompletableFuture<NodeId> getConditionClassId() {
        return this.getProperty(ConditionType.CONDITION_CLASS_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionClassId(NodeId value) {
        return this.setProperty(ConditionType.CONDITION_CLASS_ID, value);
    }

    public CompletableFuture<PropertyTypeNode> getConditionClassNameNode() {
        return this.getPropertyNode(ConditionType.CONDITION_CLASS_NAME);
    }

    @Override
    public CompletableFuture<LocalizedText> getConditionClassName() {
        return this.getProperty(ConditionType.CONDITION_CLASS_NAME);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionClassName(LocalizedText value) {
        return this.setProperty(ConditionType.CONDITION_CLASS_NAME, value);
    }

    public CompletableFuture<PropertyTypeNode> getConditionNameNode() {
        return this.getPropertyNode(ConditionType.CONDITION_NAME);
    }

    @Override
    public CompletableFuture<String> getConditionName() {
        return this.getProperty(ConditionType.CONDITION_NAME);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionName(String value) {
        return this.setProperty(ConditionType.CONDITION_NAME, value);
    }

    public CompletableFuture<PropertyTypeNode> getBranchIdNode() {
        return this.getPropertyNode(ConditionType.BRANCH_ID);
    }

    @Override
    public CompletableFuture<NodeId> getBranchId() {
        return this.getProperty(ConditionType.BRANCH_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setBranchId(NodeId value) {
        return this.setProperty(ConditionType.BRANCH_ID, value);
    }

    public CompletableFuture<PropertyTypeNode> getRetainNode() {
        return this.getPropertyNode(ConditionType.RETAIN);
    }

    @Override
    public CompletableFuture<Boolean> getRetain() {
        return this.getProperty(ConditionType.RETAIN);
    }

    @Override
    public CompletableFuture<StatusCode> setRetain(Boolean value) {
        return this.setProperty(ConditionType.RETAIN, value);
    }

    public CompletableFuture<PropertyTypeNode> getClientUserIdNode() {
        return this.getPropertyNode(ConditionType.CLIENT_USER_ID);
    }

    @Override
    public CompletableFuture<String> getClientUserId() {
        return this.getProperty(ConditionType.CLIENT_USER_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setClientUserId(String value) {
        return this.setProperty(ConditionType.CLIENT_USER_ID, value);
    }

    public CompletableFuture<TwoStateVariableTypeNode> getEnabledStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState").thenApply(TwoStateVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.getEnabledStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.getEnabledStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableTypeNode> getQualityNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "Quality").thenApply(ConditionVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<StatusCode> getQuality() {
        return ((CompletableFuture)this.getQualityNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, StatusCode.class));
    }

    @Override
    public CompletableFuture<StatusCode> setQuality(StatusCode value) {
        return this.getQualityNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableTypeNode> getLastSeverityNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "LastSeverity").thenApply(ConditionVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<UShort> getLastSeverity() {
        return ((CompletableFuture)this.getLastSeverityNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, UShort.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastSeverity(UShort value) {
        return this.getLastSeverityNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableTypeNode> getCommentNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "Comment").thenApply(ConditionVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getComment() {
        return ((CompletableFuture)this.getCommentNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setComment(LocalizedText value) {
        return this.getCommentNode().thenCompose(node -> node.setValue(value));
    }
}

