/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AggregateConfigurationTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.HistoricalDataConfigurationType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ExceptionDeviationFormat;

public class HistoricalDataConfigurationTypeNode
extends BaseObjectTypeNode
implements HistoricalDataConfigurationType {
    public HistoricalDataConfigurationTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getSteppedNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.STEPPED);
    }

    @Override
    public CompletableFuture<Boolean> getStepped() {
        return this.getProperty(HistoricalDataConfigurationType.STEPPED);
    }

    @Override
    public CompletableFuture<StatusCode> setStepped(Boolean value) {
        return this.setProperty(HistoricalDataConfigurationType.STEPPED, value);
    }

    public CompletableFuture<PropertyTypeNode> getDefinitionNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.DEFINITION);
    }

    @Override
    public CompletableFuture<String> getDefinition() {
        return this.getProperty(HistoricalDataConfigurationType.DEFINITION);
    }

    @Override
    public CompletableFuture<StatusCode> setDefinition(String value) {
        return this.setProperty(HistoricalDataConfigurationType.DEFINITION, value);
    }

    public CompletableFuture<PropertyTypeNode> getMaxTimeIntervalNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.MAX_TIME_INTERVAL);
    }

    @Override
    public CompletableFuture<Double> getMaxTimeInterval() {
        return this.getProperty(HistoricalDataConfigurationType.MAX_TIME_INTERVAL);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxTimeInterval(Double value) {
        return this.setProperty(HistoricalDataConfigurationType.MAX_TIME_INTERVAL, value);
    }

    public CompletableFuture<PropertyTypeNode> getMinTimeIntervalNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.MIN_TIME_INTERVAL);
    }

    @Override
    public CompletableFuture<Double> getMinTimeInterval() {
        return this.getProperty(HistoricalDataConfigurationType.MIN_TIME_INTERVAL);
    }

    @Override
    public CompletableFuture<StatusCode> setMinTimeInterval(Double value) {
        return this.setProperty(HistoricalDataConfigurationType.MIN_TIME_INTERVAL, value);
    }

    public CompletableFuture<PropertyTypeNode> getExceptionDeviationNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.EXCEPTION_DEVIATION);
    }

    @Override
    public CompletableFuture<Double> getExceptionDeviation() {
        return this.getProperty(HistoricalDataConfigurationType.EXCEPTION_DEVIATION);
    }

    @Override
    public CompletableFuture<StatusCode> setExceptionDeviation(Double value) {
        return this.setProperty(HistoricalDataConfigurationType.EXCEPTION_DEVIATION, value);
    }

    public CompletableFuture<PropertyTypeNode> getExceptionDeviationFormatNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.EXCEPTION_DEVIATION_FORMAT);
    }

    @Override
    public CompletableFuture<ExceptionDeviationFormat> getExceptionDeviationFormat() {
        return this.getProperty(HistoricalDataConfigurationType.EXCEPTION_DEVIATION_FORMAT);
    }

    @Override
    public CompletableFuture<StatusCode> setExceptionDeviationFormat(ExceptionDeviationFormat value) {
        return this.setProperty(HistoricalDataConfigurationType.EXCEPTION_DEVIATION_FORMAT, value);
    }

    public CompletableFuture<PropertyTypeNode> getStartOfArchiveNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.START_OF_ARCHIVE);
    }

    @Override
    public CompletableFuture<DateTime> getStartOfArchive() {
        return this.getProperty(HistoricalDataConfigurationType.START_OF_ARCHIVE);
    }

    @Override
    public CompletableFuture<StatusCode> setStartOfArchive(DateTime value) {
        return this.setProperty(HistoricalDataConfigurationType.START_OF_ARCHIVE, value);
    }

    public CompletableFuture<PropertyTypeNode> getStartOfOnlineArchiveNode() {
        return this.getPropertyNode(HistoricalDataConfigurationType.START_OF_ONLINE_ARCHIVE);
    }

    @Override
    public CompletableFuture<DateTime> getStartOfOnlineArchive() {
        return this.getProperty(HistoricalDataConfigurationType.START_OF_ONLINE_ARCHIVE);
    }

    @Override
    public CompletableFuture<StatusCode> setStartOfOnlineArchive(DateTime value) {
        return this.setProperty(HistoricalDataConfigurationType.START_OF_ONLINE_ARCHIVE, value);
    }

    public CompletableFuture<AggregateConfigurationTypeNode> getAggregateConfigurationNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "AggregateConfiguration").thenApply(AggregateConfigurationTypeNode.class::cast);
    }

    public CompletableFuture<FolderTypeNode> getAggregateFunctionsNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "AggregateFunctions").thenApply(FolderTypeNode.class::cast);
    }
}

