/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ProgramDiagnosticTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;

public class ProgramStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    public ProgramStateMachineTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getCreatableNode() {
        return this.getPropertyNode(ProgramStateMachineType.CREATABLE);
    }

    @Override
    public CompletableFuture<Boolean> getCreatable() {
        return this.getProperty(ProgramStateMachineType.CREATABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setCreatable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    public CompletableFuture<PropertyTypeNode> getDeletableNode() {
        return this.getPropertyNode(ProgramStateMachineType.DELETABLE);
    }

    @Override
    public CompletableFuture<Boolean> getDeletable() {
        return this.getProperty(ProgramStateMachineType.DELETABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setDeletable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    public CompletableFuture<PropertyTypeNode> getAutoDeleteNode() {
        return this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE);
    }

    @Override
    public CompletableFuture<Boolean> getAutoDelete() {
        return this.getProperty(ProgramStateMachineType.AUTO_DELETE);
    }

    @Override
    public CompletableFuture<StatusCode> setAutoDelete(Boolean value) {
        return this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    public CompletableFuture<PropertyTypeNode> getRecycleCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<Integer> getRecycleCount() {
        return this.getProperty(ProgramStateMachineType.RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setRecycleCount(Integer value) {
        return this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    public CompletableFuture<PropertyTypeNode> getInstanceCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getInstanceCount() {
        return this.getProperty(ProgramStateMachineType.INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyTypeNode> getMaxInstanceCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getMaxInstanceCount() {
        return this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyTypeNode> getMaxRecycleCountNode() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<UInteger> getMaxRecycleCount() {
        return this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxRecycleCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public CompletableFuture<FiniteStateVariableTypeNode> getCurrentStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentState").thenApply(FiniteStateVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getCurrentState() {
        return ((CompletableFuture)this.getCurrentStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setCurrentState(LocalizedText value) {
        return this.getCurrentStateNode().thenCompose(node -> node.setValue(value));
    }

    @Override
    public CompletableFuture<FiniteTransitionVariableTypeNode> getLastTransitionNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "LastTransition").thenApply(FiniteTransitionVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getLastTransition() {
        return ((CompletableFuture)this.getLastTransitionNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastTransition(LocalizedText value) {
        return this.getLastTransitionNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ProgramDiagnosticTypeNode> getProgramDiagnosticsNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ProgramDiagnostics").thenApply(ProgramDiagnosticTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<ProgramDiagnosticDataType> getProgramDiagnostics() {
        return ((CompletableFuture)this.getProgramDiagnosticsNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, ProgramDiagnosticDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setProgramDiagnostics(ProgramDiagnosticDataType value) {
        return this.getProgramDiagnosticsNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseObjectTypeNode> getFinalResultDataNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "FinalResultData").thenApply(BaseObjectTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Ready").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Running").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getSuspendedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Suspended").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Halted").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getHaltedToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "HaltedToReady").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getReadyToRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToRunning").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getRunningToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToHalted").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getRunningToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToReady").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getRunningToSuspendedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "RunningToSuspended").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getSuspendedToRunningNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToRunning").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getSuspendedToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToHalted").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getSuspendedToReadyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SuspendedToReady").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getReadyToHaltedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ReadyToHalted").thenApply(TransitionTypeNode.class::cast);
    }
}

