/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.CertificateGroupFolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerConfigurationType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ServerConfigurationTypeNode
extends BaseObjectTypeNode
implements ServerConfigurationType {
    public ServerConfigurationTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getServerCapabilitiesNode() {
        return this.getPropertyNode(ServerConfigurationType.SERVER_CAPABILITIES);
    }

    @Override
    public CompletableFuture<String[]> getServerCapabilities() {
        return this.getProperty(ServerConfigurationType.SERVER_CAPABILITIES);
    }

    @Override
    public CompletableFuture<StatusCode> setServerCapabilities(String[] value) {
        return this.setProperty(ServerConfigurationType.SERVER_CAPABILITIES, value);
    }

    public CompletableFuture<PropertyTypeNode> getSupportedPrivateKeyFormatsNode() {
        return this.getPropertyNode(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS);
    }

    @Override
    public CompletableFuture<String[]> getSupportedPrivateKeyFormats() {
        return this.getProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS);
    }

    @Override
    public CompletableFuture<StatusCode> setSupportedPrivateKeyFormats(String[] value) {
        return this.setProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS, value);
    }

    public CompletableFuture<PropertyTypeNode> getMaxTrustListSizeNode() {
        return this.getPropertyNode(ServerConfigurationType.MAX_TRUST_LIST_SIZE);
    }

    @Override
    public CompletableFuture<UInteger> getMaxTrustListSize() {
        return this.getProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxTrustListSize(UInteger value) {
        return this.setProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE, value);
    }

    public CompletableFuture<PropertyTypeNode> getMulticastDnsEnabledNode() {
        return this.getPropertyNode(ServerConfigurationType.MULTICAST_DNS_ENABLED);
    }

    @Override
    public CompletableFuture<Boolean> getMulticastDnsEnabled() {
        return this.getProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED);
    }

    @Override
    public CompletableFuture<StatusCode> setMulticastDnsEnabled(Boolean value) {
        return this.setProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED, value);
    }

    public CompletableFuture<CertificateGroupFolderTypeNode> getCertificateGroupsNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "CertificateGroups").thenApply(CertificateGroupFolderTypeNode.class::cast);
    }
}

