/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.SessionsDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SamplingIntervalDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SubscriptionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;

public class ServerDiagnosticsTypeNode
extends BaseObjectTypeNode
implements ServerDiagnosticsType {
    public ServerDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getEnabledFlagNode() {
        return this.getPropertyNode(ServerDiagnosticsType.ENABLED_FLAG);
    }

    @Override
    public CompletableFuture<Boolean> getEnabledFlag() {
        return this.getProperty(ServerDiagnosticsType.ENABLED_FLAG);
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledFlag(Boolean value) {
        return this.setProperty(ServerDiagnosticsType.ENABLED_FLAG, value);
    }

    public CompletableFuture<ServerDiagnosticsSummaryTypeNode> getServerDiagnosticsSummaryNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary").thenApply(ServerDiagnosticsSummaryTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<ServerDiagnosticsSummaryDataType> getServerDiagnosticsSummary() {
        return ((CompletableFuture)this.getServerDiagnosticsSummaryNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, ServerDiagnosticsSummaryDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType value) {
        return this.getServerDiagnosticsSummaryNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SamplingIntervalDiagnosticsArrayTypeNode> getSamplingIntervalDiagnosticsArrayNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray").thenApply(SamplingIntervalDiagnosticsArrayTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<SamplingIntervalDiagnosticsDataType[]> getSamplingIntervalDiagnosticsArray() {
        return ((CompletableFuture)this.getSamplingIntervalDiagnosticsArrayNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, SamplingIntervalDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] value) {
        return this.getSamplingIntervalDiagnosticsArrayNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SubscriptionDiagnosticsArrayTypeNode> getSubscriptionDiagnosticsArrayNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray").thenApply(SubscriptionDiagnosticsArrayTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<SubscriptionDiagnosticsDataType[]> getSubscriptionDiagnosticsArray() {
        return ((CompletableFuture)this.getSubscriptionDiagnosticsArrayNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, SubscriptionDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] value) {
        return this.getSubscriptionDiagnosticsArrayNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SessionsDiagnosticsSummaryTypeNode> getSessionsDiagnosticsSummaryNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary").thenApply(SessionsDiagnosticsSummaryTypeNode.class::cast);
    }
}

