/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.NamespacesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerCapabilitiesTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerRedundancyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.VendorServerInfoTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;

public class ServerTypeNode
extends BaseObjectTypeNode
implements ServerType {
    public ServerTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getServerArrayNode() {
        return this.getPropertyNode(ServerType.SERVER_ARRAY);
    }

    @Override
    public CompletableFuture<String[]> getServerArray() {
        return this.getProperty(ServerType.SERVER_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setServerArray(String[] value) {
        return this.setProperty(ServerType.SERVER_ARRAY, value);
    }

    public CompletableFuture<PropertyTypeNode> getNamespaceArrayNode() {
        return this.getPropertyNode(ServerType.NAMESPACE_ARRAY);
    }

    @Override
    public CompletableFuture<String[]> getNamespaceArray() {
        return this.getProperty(ServerType.NAMESPACE_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setNamespaceArray(String[] value) {
        return this.setProperty(ServerType.NAMESPACE_ARRAY, value);
    }

    public CompletableFuture<PropertyTypeNode> getServiceLevelNode() {
        return this.getPropertyNode(ServerType.SERVICE_LEVEL);
    }

    @Override
    public CompletableFuture<UByte> getServiceLevel() {
        return this.getProperty(ServerType.SERVICE_LEVEL);
    }

    @Override
    public CompletableFuture<StatusCode> setServiceLevel(UByte value) {
        return this.setProperty(ServerType.SERVICE_LEVEL, value);
    }

    public CompletableFuture<PropertyTypeNode> getAuditingNode() {
        return this.getPropertyNode(ServerType.AUDITING);
    }

    @Override
    public CompletableFuture<Boolean> getAuditing() {
        return this.getProperty(ServerType.AUDITING);
    }

    @Override
    public CompletableFuture<StatusCode> setAuditing(Boolean value) {
        return this.setProperty(ServerType.AUDITING, value);
    }

    public CompletableFuture<PropertyTypeNode> getEstimatedReturnTimeNode() {
        return this.getPropertyNode(ServerType.ESTIMATED_RETURN_TIME);
    }

    @Override
    public CompletableFuture<DateTime> getEstimatedReturnTime() {
        return this.getProperty(ServerType.ESTIMATED_RETURN_TIME);
    }

    @Override
    public CompletableFuture<StatusCode> setEstimatedReturnTime(DateTime value) {
        return this.setProperty(ServerType.ESTIMATED_RETURN_TIME, value);
    }

    public CompletableFuture<ServerStatusTypeNode> getServerStatusNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ServerStatus").thenApply(ServerStatusTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<ServerStatusDataType> getServerStatus() {
        return ((CompletableFuture)this.getServerStatusNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, ServerStatusDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setServerStatus(ServerStatusDataType value) {
        return this.getServerStatusNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ServerCapabilitiesTypeNode> getServerCapabilitiesNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ServerCapabilities").thenApply(ServerCapabilitiesTypeNode.class::cast);
    }

    public CompletableFuture<ServerDiagnosticsTypeNode> getServerDiagnosticsNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ServerDiagnostics").thenApply(ServerDiagnosticsTypeNode.class::cast);
    }

    public CompletableFuture<VendorServerInfoTypeNode> getVendorServerInfoNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "VendorServerInfo").thenApply(VendorServerInfoTypeNode.class::cast);
    }

    public CompletableFuture<ServerRedundancyTypeNode> getServerRedundancyNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ServerRedundancy").thenApply(ServerRedundancyTypeNode.class::cast);
    }

    public CompletableFuture<NamespacesTypeNode> getNamespacesNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Namespaces").thenApply(NamespacesTypeNode.class::cast);
    }
}

