/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ShelvedStateMachineType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ShelvedStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyTypeNode> getUnshelveTimeNode() {
        return this.getPropertyNode(ShelvedStateMachineType.UNSHELVE_TIME);
    }

    @Override
    public CompletableFuture<Double> getUnshelveTime() {
        return this.getProperty(ShelvedStateMachineType.UNSHELVE_TIME);
    }

    @Override
    public CompletableFuture<StatusCode> setUnshelveTime(Double value) {
        return this.setProperty(ShelvedStateMachineType.UNSHELVE_TIME, value);
    }

    public CompletableFuture<StateTypeNode> getUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "Unshelved").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelved").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<StateTypeNode> getOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelved").thenApply(StateTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getUnshelvedToTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "UnshelvedToTimedShelved").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getUnshelvedToOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "UnshelvedToOneShotShelved").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getTimedShelvedToUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelvedToUnshelved").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getTimedShelvedToOneShotShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "TimedShelvedToOneShotShelved").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getOneShotShelvedToUnshelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelvedToUnshelved").thenApply(TransitionTypeNode.class::cast);
    }

    public CompletableFuture<TransitionTypeNode> getOneShotShelvedToTimedShelvedNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OneShotShelvedToTimedShelved").thenApply(TransitionTypeNode.class::cast);
    }
}

