/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.StateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.TransitionEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class TransitionEventTypeNode
extends BaseEventTypeNode
implements TransitionEventType {
    public TransitionEventTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<TransitionVariableTypeNode> getTransitionNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "Transition").thenApply(TransitionVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getTransition() {
        return ((CompletableFuture)this.getTransitionNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setTransition(LocalizedText value) {
        return this.getTransitionNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<StateVariableTypeNode> getFromStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "FromState").thenApply(StateVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getFromState() {
        return ((CompletableFuture)this.getFromStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setFromState(LocalizedText value) {
        return this.getFromStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<StateVariableTypeNode> getToStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ToState").thenApply(StateVariableTypeNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getToState() {
        return ((CompletableFuture)this.getToStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setToState(LocalizedText value) {
        return this.getToStateNode().thenCompose(node -> node.setValue(value));
    }
}

