/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    public UaDataTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<Boolean> getIsAbstract() {
        return this.getAttributeOrFail(this.readIsAbstract());
    }

    @Override
    public CompletableFuture<StatusCode> setIsAbstract(boolean isAbstract) {
        return this.writeIsAbstract(DataValue.valueOnly((Variant)new Variant((Object)isAbstract)));
    }

    @Override
    public CompletableFuture<DataValue> readIsAbstract() {
        return this.readAttribute(AttributeId.IsAbstract);
    }

    @Override
    public CompletableFuture<StatusCode> writeIsAbstract(DataValue value) {
        return this.writeAttribute(AttributeId.IsAbstract, value);
    }

    public CompletableFuture<String> getNodeVersion() {
        return this.getProperty(DataTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<LocalizedText[]> getEnumStrings() {
        return this.getProperty(DataTypeNodeProperties.EnumStrings);
    }

    public CompletableFuture<EnumValueType[]> getEnumValues() {
        return this.getProperty(DataTypeNodeProperties.EnumValues);
    }

    public CompletableFuture<LocalizedText[]> getOptionSetValues() {
        return this.getProperty(DataTypeNodeProperties.OptionSetValues);
    }

    public CompletableFuture<StatusCode> setNodeVersion(String nodeVersion) {
        return this.setProperty(DataTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> setEnumStrings(LocalizedText[] enumStrings) {
        return this.setProperty(DataTypeNodeProperties.EnumStrings, enumStrings);
    }

    public CompletableFuture<StatusCode> setEnumValues(EnumValueType[] enumValues) {
        return this.setProperty(DataTypeNodeProperties.EnumValues, enumValues);
    }

    public CompletableFuture<StatusCode> setOptionSetValues(LocalizedText[] optionSetValues) {
        return this.setProperty(DataTypeNodeProperties.OptionSetValues, optionSetValues);
    }
}

