/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class UaObjectTypeNode
extends UaNode
implements ObjectTypeNode {
    public UaObjectTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<Boolean> getIsAbstract() {
        return this.getAttributeOrFail(this.readIsAbstract());
    }

    @Override
    public CompletableFuture<StatusCode> setIsAbstract(boolean isAbstract) {
        return this.writeIsAbstract(DataValue.valueOnly((Variant)new Variant((Object)isAbstract)));
    }

    @Override
    public CompletableFuture<DataValue> readIsAbstract() {
        return this.readAttribute(AttributeId.IsAbstract);
    }

    @Override
    public CompletableFuture<StatusCode> writeIsAbstract(DataValue value) {
        return this.writeAttribute(AttributeId.IsAbstract, value);
    }

    public CompletableFuture<String> getNodeVersion() {
        return this.getProperty(ObjectTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<ByteString> getIcon() {
        return this.getProperty(ObjectTypeNodeProperties.Icon);
    }

    public CompletableFuture<StatusCode> setNodeVersion(String nodeVersion) {
        return this.setProperty(ObjectTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public CompletableFuture<StatusCode> setIcon(ByteString icon) {
        return this.setProperty(ObjectTypeNodeProperties.Icon, icon);
    }
}

