/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public class OpcUaMonitoredItem
implements UaMonitoredItem {
    private final OpcUaClient client;
    private volatile UaMonitoredItem.ValueConsumer valueConsumer;
    private volatile UaMonitoredItem.EventConsumer eventConsumer;
    private volatile double requestedSamplingInterval = 0.0;
    private volatile UInteger requestedQueueSize = Unsigned.uint((int)0);
    private volatile StatusCode statusCode;
    private volatile double revisedSamplingInterval = 0.0;
    private volatile UInteger revisedQueueSize = Unsigned.uint((int)0);
    private volatile ExtensionObject filterResult;
    private volatile MonitoringMode monitoringMode = MonitoringMode.Disabled;
    private volatile ExtensionObject monitoringFilter;
    private final UInteger clientHandle;
    private final ReadValueId readValueId;
    private final UInteger monitoredItemId;

    public OpcUaMonitoredItem(OpcUaClient client, UInteger clientHandle, ReadValueId readValueId, UInteger monitoredItemId, StatusCode statusCode, double revisedSamplingInterval, UInteger revisedQueueSize, ExtensionObject filterResult, MonitoringMode monitoringMode, ExtensionObject monitoringFilter) {
        this.client = client;
        this.clientHandle = clientHandle;
        this.readValueId = readValueId;
        this.monitoredItemId = monitoredItemId;
        this.statusCode = statusCode;
        this.revisedSamplingInterval = revisedSamplingInterval;
        this.revisedQueueSize = revisedQueueSize;
        this.filterResult = filterResult;
        this.monitoringMode = monitoringMode;
        this.monitoringFilter = monitoringFilter;
    }

    @Override
    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    @Override
    public ReadValueId getReadValueId() {
        return this.readValueId;
    }

    @Override
    public UInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public double getRequestedSamplingInterval() {
        return this.requestedSamplingInterval;
    }

    @Override
    public double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    @Override
    public UInteger getRequestedQueueSize() {
        return this.requestedQueueSize;
    }

    @Override
    public UInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    @Override
    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    @Override
    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    @Override
    public ExtensionObject getMonitoringFilter() {
        return this.monitoringFilter;
    }

    @Override
    public void setValueConsumer(Consumer<DataValue> consumer) {
        this.valueConsumer = (context, item, value) -> consumer.accept(value);
    }

    @Override
    public void setValueConsumer(BiConsumer<UaMonitoredItem, DataValue> valueBiConsumer) {
        this.valueConsumer = (context, item, value) -> valueBiConsumer.accept(item, value);
    }

    @Override
    public void setValueConsumer(UaMonitoredItem.ValueConsumer valueConsumer) {
        this.valueConsumer = valueConsumer;
    }

    @Override
    public void setEventConsumer(Consumer<Variant[]> consumer) {
        this.eventConsumer = (dataTypeManager, item, values) -> consumer.accept(values);
    }

    @Override
    public void setEventConsumer(BiConsumer<UaMonitoredItem, Variant[]> eventBiConsumer) {
        this.eventConsumer = (dataTypeManager, item, values) -> eventBiConsumer.accept(item, values);
    }

    @Override
    public void setEventConsumer(UaMonitoredItem.EventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    void setFilterResult(ExtensionObject filterResult) {
        this.filterResult = filterResult;
    }

    void setRequestedSamplingInterval(double requestedSamplingInterval) {
        this.requestedSamplingInterval = requestedSamplingInterval;
    }

    void setRevisedSamplingInterval(double revisedSamplingInterval) {
        this.revisedSamplingInterval = revisedSamplingInterval;
    }

    void setRequestedQueueSize(UInteger requestedQueueSize) {
        this.requestedQueueSize = requestedQueueSize;
    }

    void setRevisedQueueSize(UInteger revisedQueueSize) {
        this.revisedQueueSize = revisedQueueSize;
    }

    void setMonitoringMode(MonitoringMode monitoringMode) {
        this.monitoringMode = monitoringMode;
    }

    void onValueArrived(DataValue value) {
        UaMonitoredItem.ValueConsumer c = this.valueConsumer;
        if (c != null) {
            c.onValueArrived(this.client.getSerializationContext(), this, value);
        }
    }

    void onEventArrived(Variant[] values) {
        UaMonitoredItem.EventConsumer c = this.eventConsumer;
        if (c != null) {
            c.onEventArrived(this.client.getSerializationContext(), this, values);
        }
    }
}

