/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.BrowseHelper;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.core.DataTypeTree;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public final class DataTypeTreeBuilder {
    private DataTypeTreeBuilder() {
    }

    public static DataTypeTree build(OpcUaClient client) throws UaException {
        try {
            return DataTypeTreeBuilder.buildAsync(client).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public static DataTypeTree build(UaStackClient client, OpcUaSession session) throws UaException {
        try {
            return DataTypeTreeBuilder.buildAsync(client, session).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public static CompletableFuture<DataTypeTree> buildAsync(OpcUaClient client) {
        return client.getSession().thenCompose(session -> DataTypeTreeBuilder.buildAsync(client.getStackClient(), session));
    }

    public static CompletableFuture<DataTypeTree> buildAsync(UaStackClient client, OpcUaSession session) {
        Tree root = new Tree(null, (Object)new DataTypeTree.DataType(QualifiedName.parse((String)"0:BaseDataType"), Identifiers.BaseDataType, null, null));
        return ((CompletableFuture)DataTypeTreeBuilder.readNamespaceTable(client, session).thenCompose(namespaceTable -> DataTypeTreeBuilder.addChildren((Tree<DataTypeTree.DataType>)root, client, session, namespaceTable))).thenApply(u -> new DataTypeTree(root));
    }

    private static CompletableFuture<NamespaceTable> readNamespaceTable(UaStackClient client, OpcUaSession session) {
        RequestHeader requestHeader = client.newRequestHeader(session.getAuthenticationToken(), client.getConfig().getRequestTimeout());
        CompletableFuture readFuture = client.sendRequest((UaRequestMessage)new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(Identifiers.Server_NamespaceArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)}));
        return ((CompletableFuture)readFuture.thenApply(ReadResponse.class::cast)).thenApply(response -> {
            DataValue dataValue = response.getResults()[0];
            String[] namespaceUris = (String[])dataValue.getValue().getValue();
            NamespaceTable namespaceTable = new NamespaceTable();
            for (String namespaceUri : namespaceUris) {
                namespaceTable.addUri(namespaceUri);
            }
            return namespaceTable;
        });
    }

    private static CompletableFuture<Unit> addChildren(Tree<DataTypeTree.DataType> tree, UaStackClient client, OpcUaSession session, NamespaceTable namespaceTable) {
        CompletableFuture<List<ReferenceDescription>> subtypes = DataTypeTreeBuilder.browseSafe(client, session, new BrowseDescription(((DataTypeTree.DataType)tree.getValue()).getNodeId(), BrowseDirection.Forward, Identifiers.HasSubtype, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.DataType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
        CompletionStage dataTypesFuture = subtypes.thenCompose(references -> {
            Stream<CompletableFuture> dataTypeFutures = references.stream().map(dataTypeReference -> {
                NodeId dataTypeId = dataTypeReference.getNodeId().local(namespaceTable).orElse(NodeId.NULL_VALUE);
                CompletableFuture<List<ReferenceDescription>> encodings = DataTypeTreeBuilder.browseSafe(client, session, new BrowseDescription(dataTypeId, BrowseDirection.Forward, Identifiers.HasEncoding, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Object.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
                return encodings.thenApply(encodingReferences -> {
                    NodeId binaryEncodingId = null;
                    NodeId xmlEncodingId = null;
                    for (ReferenceDescription r : encodingReferences) {
                        if (r.getBrowseName().equals((Object)OpcUaDefaultBinaryEncoding.ENCODING_NAME)) {
                            binaryEncodingId = r.getNodeId().local(namespaceTable).orElse(null);
                            continue;
                        }
                        if (!r.getBrowseName().equals((Object)OpcUaDefaultXmlEncoding.ENCODING_NAME)) continue;
                        xmlEncodingId = r.getNodeId().local(namespaceTable).orElse(null);
                    }
                    return new DataTypeTree.DataType(dataTypeReference.getBrowseName(), dataTypeId, binaryEncodingId, xmlEncodingId);
                });
            });
            return FutureUtils.sequence(dataTypeFutures);
        });
        return ((CompletableFuture)((CompletableFuture)dataTypesFuture).thenCompose(dataTypes -> {
            Stream<CompletableFuture> futures = dataTypes.stream().map(arg_0 -> ((Tree)tree).addChild(arg_0)).map(childNode -> DataTypeTreeBuilder.addChildren((Tree<DataTypeTree.DataType>)childNode, client, session, namespaceTable));
            return FutureUtils.sequence(futures);
        })).thenApply(v -> Unit.VALUE);
    }

    private static CompletableFuture<List<ReferenceDescription>> browseSafe(UaStackClient client, OpcUaSession session, BrowseDescription browseDescription) {
        return BrowseHelper.browse(client, session, browseDescription).exceptionally(ex -> Collections.emptyList());
    }
}

