/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.config;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.MessageLimits;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class OpcUaClientConfigBuilder
extends UaStackClientConfigBuilder {
    private LocalizedText applicationName = LocalizedText.english((String)"Eclipse Milo application name not configured");
    private String applicationUri = "urn:eclipse:milo:client:applicationUriNotConfigured";
    private String productUri = "https://github.com/eclipse/milo";
    private Supplier<String> sessionName;
    private String[] sessionLocaleIds = new String[0];
    private UInteger sessionTimeout = Unsigned.uint((int)120000);
    private IdentityProvider identityProvider = new AnonymousProvider();
    private UInteger maxResponseMessageSize = Unsigned.uint((int)0);
    private UInteger maxPendingPublishRequests = Unsigned.uint((long)0xFFFFFFFFL);
    private UInteger keepAliveFailuresAllowed = Unsigned.uint((int)1);
    private UInteger keepAliveInterval = Unsigned.uint((int)5000);
    private UInteger keepAliveTimeout = Unsigned.uint((int)5000);

    public OpcUaClientConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public OpcUaClientConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public OpcUaClientConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionName(Supplier<String> sessionName) {
        this.sessionName = sessionName;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionLocaleIds(String[] sessionLocaleIds) {
        this.sessionLocaleIds = sessionLocaleIds;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionTimeout(UInteger sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxResponseMessageSize(UInteger maxResponseMessageSize) {
        this.maxResponseMessageSize = maxResponseMessageSize;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxPendingPublishRequests(UInteger maxPendingPublishRequests) {
        this.maxPendingPublishRequests = maxPendingPublishRequests;
        return this;
    }

    public OpcUaClientConfigBuilder setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveFailuresAllowed(UInteger keepAliveFailuresAllowed) {
        this.keepAliveFailuresAllowed = keepAliveFailuresAllowed;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveInterval(UInteger keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveTimeout(UInteger keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setEndpoint(EndpointDescription endpoint) {
        super.setEndpoint(endpoint);
        return this;
    }

    public OpcUaClientConfigBuilder setKeyPair(KeyPair keyPair) {
        super.setKeyPair(keyPair);
        return this;
    }

    public OpcUaClientConfigBuilder setCertificate(X509Certificate certificate) {
        super.setCertificate(certificate);
        return this;
    }

    public OpcUaClientConfigBuilder setCertificateChain(X509Certificate[] certificateChain) {
        super.setCertificateChain(certificateChain);
        return this;
    }

    public OpcUaClientConfigBuilder setCertificateValidator(ClientCertificateValidator certificateValidator) {
        super.setCertificateValidator(certificateValidator);
        return this;
    }

    public OpcUaClientConfigBuilder setMessageLimits(MessageLimits messageLimits) {
        super.setMessageLimits(messageLimits);
        return this;
    }

    public OpcUaClientConfigBuilder setChannelLifetime(UInteger channelLifetime) {
        super.setChannelLifetime(channelLifetime);
        return this;
    }

    public OpcUaClientConfigBuilder setExecutor(ExecutorService executor) {
        super.setExecutor(executor);
        return this;
    }

    public OpcUaClientConfigBuilder setEventLoop(NioEventLoopGroup eventLoop) {
        super.setEventLoop(eventLoop);
        return this;
    }

    public OpcUaClientConfigBuilder setWheelTimer(HashedWheelTimer wheelTimer) {
        super.setWheelTimer(wheelTimer);
        return this;
    }

    public OpcUaClientConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        super.setEncodingLimits(encodingLimits);
        return this;
    }

    public OpcUaClientConfigBuilder setConnectTimeout(UInteger connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public OpcUaClientConfigBuilder setAcknowledgeTimeout(UInteger acknowledgeTimeout) {
        super.setAcknowledgeTimeout(acknowledgeTimeout);
        return this;
    }

    public OpcUaClientConfigBuilder setRequestTimeout(UInteger requestTimeout) {
        super.setRequestTimeout(requestTimeout);
        return this;
    }

    public OpcUaClientConfig build() {
        UaStackClientConfig stackClientConfig = super.build();
        if (this.sessionName == null) {
            this.sessionName = () -> String.format("UaSession:%s:%s", this.applicationName.getText(), System.currentTimeMillis());
        }
        return new OpcUaClientConfigImpl(stackClientConfig, this.applicationName, this.applicationUri, this.productUri, this.sessionName, this.sessionLocaleIds, this.sessionTimeout, this.maxResponseMessageSize, this.maxPendingPublishRequests, this.identityProvider, this.keepAliveFailuresAllowed, this.keepAliveInterval, this.keepAliveTimeout);
    }

    static class OpcUaClientConfigImpl
    implements OpcUaClientConfig {
        private final UaStackClientConfig stackClientConfig;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final Supplier<String> sessionName;
        private final String[] sessionLocaleIds;
        private final UInteger sessionTimeout;
        private final UInteger maxResponseMessageSize;
        private final UInteger maxPendingPublishRequests;
        private final IdentityProvider identityProvider;
        private final UInteger keepAliveFailuresAllowed;
        private final UInteger keepAliveInterval;
        private final UInteger keepAliveTimeout;

        OpcUaClientConfigImpl(UaStackClientConfig stackClientConfig, LocalizedText applicationName, String applicationUri, String productUri, Supplier<String> sessionName, String[] sessionLocaleIds, UInteger sessionTimeout, UInteger maxResponseMessageSize, UInteger maxPendingPublishRequests, IdentityProvider identityProvider, UInteger keepAliveFailuresAllowed, UInteger keepAliveInterval, UInteger keepAliveTimeout) {
            this.stackClientConfig = stackClientConfig;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.sessionName = sessionName;
            this.sessionLocaleIds = sessionLocaleIds;
            this.sessionTimeout = sessionTimeout;
            this.maxResponseMessageSize = maxResponseMessageSize;
            this.maxPendingPublishRequests = maxPendingPublishRequests;
            this.identityProvider = identityProvider;
            this.keepAliveFailuresAllowed = keepAliveFailuresAllowed;
            this.keepAliveInterval = keepAliveInterval;
            this.keepAliveTimeout = keepAliveTimeout;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public Supplier<String> getSessionName() {
            return this.sessionName;
        }

        @Override
        public String[] getSessionLocaleIds() {
            return this.sessionLocaleIds;
        }

        @Override
        public UInteger getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public UInteger getMaxResponseMessageSize() {
            return this.maxResponseMessageSize;
        }

        @Override
        public UInteger getMaxPendingPublishRequests() {
            return this.maxPendingPublishRequests;
        }

        @Override
        public IdentityProvider getIdentityProvider() {
            return this.identityProvider;
        }

        @Override
        public UInteger getKeepAliveFailuresAllowed() {
            return this.keepAliveFailuresAllowed;
        }

        @Override
        public UInteger getKeepAliveInterval() {
            return this.keepAliveInterval;
        }

        @Override
        public UInteger getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public EndpointDescription getEndpoint() {
            return this.stackClientConfig.getEndpoint();
        }

        public Optional<KeyPair> getKeyPair() {
            return this.stackClientConfig.getKeyPair();
        }

        public Optional<X509Certificate> getCertificate() {
            return this.stackClientConfig.getCertificate();
        }

        public Optional<X509Certificate[]> getCertificateChain() {
            return this.stackClientConfig.getCertificateChain();
        }

        public ClientCertificateValidator getCertificateValidator() {
            return this.stackClientConfig.getCertificateValidator();
        }

        public MessageLimits getMessageLimits() {
            return this.stackClientConfig.getMessageLimits();
        }

        public EncodingLimits getEncodingLimits() {
            return this.stackClientConfig.getEncodingLimits();
        }

        public UInteger getChannelLifetime() {
            return this.stackClientConfig.getChannelLifetime();
        }

        public ExecutorService getExecutor() {
            return this.stackClientConfig.getExecutor();
        }

        public NioEventLoopGroup getEventLoop() {
            return this.stackClientConfig.getEventLoop();
        }

        public HashedWheelTimer getWheelTimer() {
            return this.stackClientConfig.getWheelTimer();
        }

        public UInteger getConnectTimeout() {
            return this.stackClientConfig.getConnectTimeout();
        }

        public UInteger getAcknowledgeTimeout() {
            return this.stackClientConfig.getAcknowledgeTimeout();
        }

        public UInteger getRequestTimeout() {
            return this.stackClientConfig.getRequestTimeout();
        }
    }
}

