/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.subscriptions;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public interface UaMonitoredItem {
    public UInteger getClientHandle();

    public UInteger getMonitoredItemId();

    public ReadValueId getReadValueId();

    public StatusCode getStatusCode();

    public double getRequestedSamplingInterval();

    public double getRevisedSamplingInterval();

    public UInteger getRequestedQueueSize();

    public UInteger getRevisedQueueSize();

    public ExtensionObject getFilterResult();

    public MonitoringMode getMonitoringMode();

    public ExtensionObject getMonitoringFilter();

    public boolean getDiscardOldest();

    public TimestampsToReturn getTimestamps();

    public void setValueConsumer(Consumer<DataValue> var1);

    public void setValueConsumer(BiConsumer<UaMonitoredItem, DataValue> var1);

    public void setValueConsumer(ValueConsumer var1);

    public void setEventConsumer(Consumer<Variant[]> var1);

    public void setEventConsumer(BiConsumer<UaMonitoredItem, Variant[]> var1);

    public void setEventConsumer(EventConsumer var1);

    public static interface EventConsumer {
        public void onEventArrived(SerializationContext var1, UaMonitoredItem var2, Variant[] var3);
    }

    public static interface ValueConsumer {
        public void onValueArrived(SerializationContext var1, UaMonitoredItem var2, DataValue var3);
    }
}

