/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AggregateConfigurationType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class AggregateConfigurationTypeNode
extends BaseObjectTypeNode
implements AggregateConfigurationType {
    public AggregateConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Boolean getTreatUncertainAsBad() throws UaException {
        PropertyTypeNode node = this.getTreatUncertainAsBadNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setTreatUncertainAsBad(Boolean treatUncertainAsBad) throws UaException {
        PropertyTypeNode node = this.getTreatUncertainAsBadNode();
        node.setValue(new Variant((Object)treatUncertainAsBad));
    }

    @Override
    public Boolean readTreatUncertainAsBad() throws UaException {
        try {
            return this.readTreatUncertainAsBadAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTreatUncertainAsBad(Boolean treatUncertainAsBad) throws UaException {
        try {
            this.writeTreatUncertainAsBadAsync(treatUncertainAsBad).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readTreatUncertainAsBadAsync() {
        return ((CompletableFuture)this.getTreatUncertainAsBadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeTreatUncertainAsBadAsync(Boolean treatUncertainAsBad) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)treatUncertainAsBad));
        return ((CompletableFuture)this.getTreatUncertainAsBadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getTreatUncertainAsBadNode() throws UaException {
        try {
            return this.getTreatUncertainAsBadNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTreatUncertainAsBadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TreatUncertainAsBad", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getPercentDataBad() throws UaException {
        PropertyTypeNode node = this.getPercentDataBadNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPercentDataBad(UByte percentDataBad) throws UaException {
        PropertyTypeNode node = this.getPercentDataBadNode();
        node.setValue(new Variant((Object)percentDataBad));
    }

    @Override
    public UByte readPercentDataBad() throws UaException {
        try {
            return this.readPercentDataBadAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePercentDataBad(UByte percentDataBad) throws UaException {
        try {
            this.writePercentDataBadAsync(percentDataBad).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPercentDataBadAsync() {
        return ((CompletableFuture)this.getPercentDataBadNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writePercentDataBadAsync(UByte percentDataBad) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)percentDataBad));
        return ((CompletableFuture)this.getPercentDataBadNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getPercentDataBadNode() throws UaException {
        try {
            return this.getPercentDataBadNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPercentDataBadNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PercentDataBad", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte getPercentDataGood() throws UaException {
        PropertyTypeNode node = this.getPercentDataGoodNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPercentDataGood(UByte percentDataGood) throws UaException {
        PropertyTypeNode node = this.getPercentDataGoodNode();
        node.setValue(new Variant((Object)percentDataGood));
    }

    @Override
    public UByte readPercentDataGood() throws UaException {
        try {
            return this.readPercentDataGoodAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePercentDataGood(UByte percentDataGood) throws UaException {
        try {
            this.writePercentDataGoodAsync(percentDataGood).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPercentDataGoodAsync() {
        return ((CompletableFuture)this.getPercentDataGoodNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writePercentDataGoodAsync(UByte percentDataGood) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)percentDataGood));
        return ((CompletableFuture)this.getPercentDataGoodNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getPercentDataGoodNode() throws UaException {
        try {
            return this.getPercentDataGoodNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPercentDataGoodNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PercentDataGood", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUseSlopedExtrapolation() throws UaException {
        PropertyTypeNode node = this.getUseSlopedExtrapolationNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUseSlopedExtrapolation(Boolean useSlopedExtrapolation) throws UaException {
        PropertyTypeNode node = this.getUseSlopedExtrapolationNode();
        node.setValue(new Variant((Object)useSlopedExtrapolation));
    }

    @Override
    public Boolean readUseSlopedExtrapolation() throws UaException {
        try {
            return this.readUseSlopedExtrapolationAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUseSlopedExtrapolation(Boolean useSlopedExtrapolation) throws UaException {
        try {
            this.writeUseSlopedExtrapolationAsync(useSlopedExtrapolation).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUseSlopedExtrapolationAsync() {
        return ((CompletableFuture)this.getUseSlopedExtrapolationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeUseSlopedExtrapolationAsync(Boolean useSlopedExtrapolation) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)useSlopedExtrapolation));
        return ((CompletableFuture)this.getUseSlopedExtrapolationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getUseSlopedExtrapolationNode() throws UaException {
        try {
            return this.getUseSlopedExtrapolationNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUseSlopedExtrapolationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UseSlopedExtrapolation", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

