/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditNodeManagementEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditAddNodesEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class AuditAddNodesEventTypeNode
extends AuditNodeManagementEventTypeNode
implements AuditAddNodesEventType {
    public AuditAddNodesEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public AddNodesItem[] getNodesToAdd() throws UaException {
        PropertyTypeNode node = this.getNodesToAddNode();
        return this.cast(node.getValue().getValue().getValue(), AddNodesItem[].class);
    }

    @Override
    public void setNodesToAdd(AddNodesItem[] nodesToAdd) throws UaException {
        PropertyTypeNode node = this.getNodesToAddNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])nodesToAdd);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public AddNodesItem[] readNodesToAdd() throws UaException {
        try {
            return this.readNodesToAddAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNodesToAdd(AddNodesItem[] nodesToAdd) throws UaException {
        try {
            this.writeNodesToAddAsync(nodesToAdd).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends AddNodesItem[]> readNodesToAddAsync() {
        return ((CompletableFuture)this.getNodesToAddNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), AddNodesItem[].class));
    }

    @Override
    public CompletableFuture<Unit> writeNodesToAddAsync(AddNodesItem[] nodesToAdd) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])nodesToAdd);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getNodesToAddNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getNodesToAddNode() throws UaException {
        try {
            return this.getNodesToAddNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNodesToAddNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NodesToAdd", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

