/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditHistoryDeleteEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditHistoryAtTimeDeleteEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class AuditHistoryAtTimeDeleteEventTypeNode
extends AuditHistoryDeleteEventTypeNode
implements AuditHistoryAtTimeDeleteEventType {
    public AuditHistoryAtTimeDeleteEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public DateTime[] getReqTimes() throws UaException {
        PropertyTypeNode node = this.getReqTimesNode();
        return (DateTime[])node.getValue().getValue().getValue();
    }

    @Override
    public void setReqTimes(DateTime[] reqTimes) throws UaException {
        PropertyTypeNode node = this.getReqTimesNode();
        node.setValue(new Variant((Object)reqTimes));
    }

    @Override
    public DateTime[] readReqTimes() throws UaException {
        try {
            return this.readReqTimesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReqTimes(DateTime[] reqTimes) throws UaException {
        try {
            this.writeReqTimesAsync(reqTimes).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime[]> readReqTimesAsync() {
        return ((CompletableFuture)this.getReqTimesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeReqTimesAsync(DateTime[] reqTimes) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)reqTimes));
        return ((CompletableFuture)this.getReqTimesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getReqTimesNode() throws UaException {
        try {
            return this.getReqTimesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReqTimesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReqTimes", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataValue[] getOldValues() throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        return (DataValue[])node.getValue().getValue().getValue();
    }

    @Override
    public void setOldValues(DataValue[] oldValues) throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        node.setValue(new Variant((Object)oldValues));
    }

    @Override
    public DataValue[] readOldValues() throws UaException {
        try {
            return this.readOldValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOldValues(DataValue[] oldValues) throws UaException {
        try {
            this.writeOldValuesAsync(oldValues).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DataValue[]> readOldValuesAsync() {
        return ((CompletableFuture)this.getOldValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DataValue[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeOldValuesAsync(DataValue[] oldValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)oldValues));
        return ((CompletableFuture)this.getOldValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getOldValuesNode() throws UaException {
        try {
            return this.getOldValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOldValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OldValues", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

