/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.BaseEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class BaseEventTypeNode
extends BaseObjectTypeNode
implements BaseEventType {
    public BaseEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public ByteString getEventId() throws UaException {
        PropertyTypeNode node = this.getEventIdNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventId(ByteString eventId) throws UaException {
        PropertyTypeNode node = this.getEventIdNode();
        node.setValue(new Variant((Object)eventId));
    }

    @Override
    public ByteString readEventId() throws UaException {
        try {
            return this.readEventIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEventId(ByteString eventId) throws UaException {
        try {
            this.writeEventIdAsync(eventId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readEventIdAsync() {
        return ((CompletableFuture)this.getEventIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeEventIdAsync(ByteString eventId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventId));
        return ((CompletableFuture)this.getEventIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getEventIdNode() throws UaException {
        try {
            return this.getEventIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEventIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getEventType() throws UaException {
        PropertyTypeNode node = this.getEventTypeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setEventType(NodeId eventType) throws UaException {
        PropertyTypeNode node = this.getEventTypeNode();
        node.setValue(new Variant((Object)eventType));
    }

    @Override
    public NodeId readEventType() throws UaException {
        try {
            return this.readEventTypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEventType(NodeId eventType) throws UaException {
        try {
            this.writeEventTypeAsync(eventType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readEventTypeAsync() {
        return ((CompletableFuture)this.getEventTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeEventTypeAsync(NodeId eventType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)eventType));
        return ((CompletableFuture)this.getEventTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getEventTypeNode() throws UaException {
        try {
            return this.getEventTypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEventTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventType", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getSourceNode() throws UaException {
        PropertyTypeNode node = this.getSourceNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSourceNode(NodeId sourceNode) throws UaException {
        PropertyTypeNode node = this.getSourceNodeNode();
        node.setValue(new Variant((Object)sourceNode));
    }

    @Override
    public NodeId readSourceNode() throws UaException {
        try {
            return this.readSourceNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSourceNode(NodeId sourceNode) throws UaException {
        try {
            this.writeSourceNodeAsync(sourceNode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSourceNodeAsync() {
        return ((CompletableFuture)this.getSourceNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeSourceNodeAsync(NodeId sourceNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sourceNode));
        return ((CompletableFuture)this.getSourceNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getSourceNodeNode() throws UaException {
        try {
            return this.getSourceNodeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSourceNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SourceNode", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSourceName() throws UaException {
        PropertyTypeNode node = this.getSourceNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSourceName(String sourceName) throws UaException {
        PropertyTypeNode node = this.getSourceNameNode();
        node.setValue(new Variant((Object)sourceName));
    }

    @Override
    public String readSourceName() throws UaException {
        try {
            return this.readSourceNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSourceName(String sourceName) throws UaException {
        try {
            this.writeSourceNameAsync(sourceName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSourceNameAsync() {
        return ((CompletableFuture)this.getSourceNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeSourceNameAsync(String sourceName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sourceName));
        return ((CompletableFuture)this.getSourceNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getSourceNameNode() throws UaException {
        try {
            return this.getSourceNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSourceNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SourceName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getTime() throws UaException {
        PropertyTypeNode node = this.getTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setTime(DateTime time) throws UaException {
        PropertyTypeNode node = this.getTimeNode();
        node.setValue(new Variant((Object)time));
    }

    @Override
    public DateTime readTime() throws UaException {
        try {
            return this.readTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTime(DateTime time) throws UaException {
        try {
            this.writeTimeAsync(time).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readTimeAsync() {
        return ((CompletableFuture)this.getTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeTimeAsync(DateTime time) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)time));
        return ((CompletableFuture)this.getTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getTimeNode() throws UaException {
        try {
            return this.getTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Time", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getReceiveTime() throws UaException {
        PropertyTypeNode node = this.getReceiveTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setReceiveTime(DateTime receiveTime) throws UaException {
        PropertyTypeNode node = this.getReceiveTimeNode();
        node.setValue(new Variant((Object)receiveTime));
    }

    @Override
    public DateTime readReceiveTime() throws UaException {
        try {
            return this.readReceiveTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReceiveTime(DateTime receiveTime) throws UaException {
        try {
            this.writeReceiveTimeAsync(receiveTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readReceiveTimeAsync() {
        return ((CompletableFuture)this.getReceiveTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeReceiveTimeAsync(DateTime receiveTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)receiveTime));
        return ((CompletableFuture)this.getReceiveTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getReceiveTimeNode() throws UaException {
        try {
            return this.getReceiveTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReceiveTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReceiveTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public TimeZoneDataType getLocalTime() throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        return this.cast(node.getValue().getValue().getValue(), TimeZoneDataType.class);
    }

    @Override
    public void setLocalTime(TimeZoneDataType localTime) throws UaException {
        PropertyTypeNode node = this.getLocalTimeNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)localTime);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public TimeZoneDataType readLocalTime() throws UaException {
        try {
            return this.readLocalTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLocalTime(TimeZoneDataType localTime) throws UaException {
        try {
            this.writeLocalTimeAsync(localTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TimeZoneDataType> readLocalTimeAsync() {
        return ((CompletableFuture)this.getLocalTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), TimeZoneDataType.class));
    }

    @Override
    public CompletableFuture<Unit> writeLocalTimeAsync(TimeZoneDataType localTime) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)localTime);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getLocalTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getLocalTimeNode() throws UaException {
        try {
            return this.getLocalTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocalTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocalTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getMessage() throws UaException {
        PropertyTypeNode node = this.getMessageNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setMessage(LocalizedText message) throws UaException {
        PropertyTypeNode node = this.getMessageNode();
        node.setValue(new Variant((Object)message));
    }

    @Override
    public LocalizedText readMessage() throws UaException {
        try {
            return this.readMessageAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMessage(LocalizedText message) throws UaException {
        try {
            this.writeMessageAsync(message).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readMessageAsync() {
        return ((CompletableFuture)this.getMessageNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMessageAsync(LocalizedText message) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)message));
        return ((CompletableFuture)this.getMessageNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMessageNode() throws UaException {
        try {
            return this.getMessageNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMessageNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Message", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getSeverity() throws UaException {
        PropertyTypeNode node = this.getSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setSeverity(UShort severity) throws UaException {
        PropertyTypeNode node = this.getSeverityNode();
        node.setValue(new Variant((Object)severity));
    }

    @Override
    public UShort readSeverity() throws UaException {
        try {
            return this.readSeverityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSeverity(UShort severity) throws UaException {
        try {
            this.writeSeverityAsync(severity).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readSeverityAsync() {
        return ((CompletableFuture)this.getSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeSeverityAsync(UShort severity) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)severity));
        return ((CompletableFuture)this.getSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getSeverityNode() throws UaException {
        try {
            return this.getSeverityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Severity", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

