/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.DialogConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class DialogConditionTypeNode
extends ConditionTypeNode
implements DialogConditionType {
    public DialogConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getPrompt() throws UaException {
        PropertyTypeNode node = this.getPromptNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setPrompt(LocalizedText prompt) throws UaException {
        PropertyTypeNode node = this.getPromptNode();
        node.setValue(new Variant((Object)prompt));
    }

    @Override
    public LocalizedText readPrompt() throws UaException {
        try {
            return this.readPromptAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePrompt(LocalizedText prompt) throws UaException {
        try {
            this.writePromptAsync(prompt).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readPromptAsync() {
        return ((CompletableFuture)this.getPromptNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writePromptAsync(LocalizedText prompt) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)prompt));
        return ((CompletableFuture)this.getPromptNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getPromptNode() throws UaException {
        try {
            return this.getPromptNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPromptNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Prompt", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getResponseOptionSet() throws UaException {
        PropertyTypeNode node = this.getResponseOptionSetNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setResponseOptionSet(LocalizedText[] responseOptionSet) throws UaException {
        PropertyTypeNode node = this.getResponseOptionSetNode();
        node.setValue(new Variant((Object)responseOptionSet));
    }

    @Override
    public LocalizedText[] readResponseOptionSet() throws UaException {
        try {
            return this.readResponseOptionSetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeResponseOptionSet(LocalizedText[] responseOptionSet) throws UaException {
        try {
            this.writeResponseOptionSetAsync(responseOptionSet).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readResponseOptionSetAsync() {
        return ((CompletableFuture)this.getResponseOptionSetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeResponseOptionSetAsync(LocalizedText[] responseOptionSet) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)responseOptionSet));
        return ((CompletableFuture)this.getResponseOptionSetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getResponseOptionSetNode() throws UaException {
        try {
            return this.getResponseOptionSetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getResponseOptionSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ResponseOptionSet", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getDefaultResponse() throws UaException {
        PropertyTypeNode node = this.getDefaultResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefaultResponse(Integer defaultResponse) throws UaException {
        PropertyTypeNode node = this.getDefaultResponseNode();
        node.setValue(new Variant((Object)defaultResponse));
    }

    @Override
    public Integer readDefaultResponse() throws UaException {
        try {
            return this.readDefaultResponseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDefaultResponse(Integer defaultResponse) throws UaException {
        try {
            this.writeDefaultResponseAsync(defaultResponse).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readDefaultResponseAsync() {
        return ((CompletableFuture)this.getDefaultResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDefaultResponseAsync(Integer defaultResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)defaultResponse));
        return ((CompletableFuture)this.getDefaultResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getDefaultResponseNode() throws UaException {
        try {
            return this.getDefaultResponseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getOkResponse() throws UaException {
        PropertyTypeNode node = this.getOkResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setOkResponse(Integer okResponse) throws UaException {
        PropertyTypeNode node = this.getOkResponseNode();
        node.setValue(new Variant((Object)okResponse));
    }

    @Override
    public Integer readOkResponse() throws UaException {
        try {
            return this.readOkResponseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOkResponse(Integer okResponse) throws UaException {
        try {
            this.writeOkResponseAsync(okResponse).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readOkResponseAsync() {
        return ((CompletableFuture)this.getOkResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeOkResponseAsync(Integer okResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)okResponse));
        return ((CompletableFuture)this.getOkResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getOkResponseNode() throws UaException {
        try {
            return this.getOkResponseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOkResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OkResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getCancelResponse() throws UaException {
        PropertyTypeNode node = this.getCancelResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setCancelResponse(Integer cancelResponse) throws UaException {
        PropertyTypeNode node = this.getCancelResponseNode();
        node.setValue(new Variant((Object)cancelResponse));
    }

    @Override
    public Integer readCancelResponse() throws UaException {
        try {
            return this.readCancelResponseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCancelResponse(Integer cancelResponse) throws UaException {
        try {
            this.writeCancelResponseAsync(cancelResponse).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readCancelResponseAsync() {
        return ((CompletableFuture)this.getCancelResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeCancelResponseAsync(Integer cancelResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)cancelResponse));
        return ((CompletableFuture)this.getCancelResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getCancelResponseNode() throws UaException {
        try {
            return this.getCancelResponseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCancelResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CancelResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getLastResponse() throws UaException {
        PropertyTypeNode node = this.getLastResponseNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastResponse(Integer lastResponse) throws UaException {
        PropertyTypeNode node = this.getLastResponseNode();
        node.setValue(new Variant((Object)lastResponse));
    }

    @Override
    public Integer readLastResponse() throws UaException {
        try {
            return this.readLastResponseAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastResponse(Integer lastResponse) throws UaException {
        try {
            this.writeLastResponseAsync(lastResponse).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readLastResponseAsync() {
        return ((CompletableFuture)this.getLastResponseNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeLastResponseAsync(Integer lastResponse) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastResponse));
        return ((CompletableFuture)this.getLastResponseNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getLastResponseNode() throws UaException {
        try {
            return this.getLastResponseNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLastResponseNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText enabledState) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant((Object)enabledState));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledState(LocalizedText enabledState) throws UaException {
        try {
            this.writeEnabledStateAsync(enabledState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledState));
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getDialogState() throws UaException {
        TwoStateVariableTypeNode node = this.getDialogStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setDialogState(LocalizedText dialogState) throws UaException {
        TwoStateVariableTypeNode node = this.getDialogStateNode();
        node.setValue(new Variant((Object)dialogState));
    }

    @Override
    public LocalizedText readDialogState() throws UaException {
        try {
            return this.readDialogStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDialogState(LocalizedText dialogState) throws UaException {
        try {
            this.writeDialogStateAsync(dialogState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readDialogStateAsync() {
        return ((CompletableFuture)this.getDialogStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDialogStateAsync(LocalizedText dialogState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dialogState));
        return ((CompletableFuture)this.getDialogStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getDialogStateNode() throws UaException {
        try {
            return this.getDialogStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getDialogStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DialogState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }
}

