/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.HistoryServerCapabilitiesType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class HistoryServerCapabilitiesTypeNode
extends BaseObjectTypeNode
implements HistoryServerCapabilitiesType {
    public HistoryServerCapabilitiesTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Boolean getAccessHistoryDataCapability() throws UaException {
        PropertyTypeNode node = this.getAccessHistoryDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAccessHistoryDataCapability(Boolean accessHistoryDataCapability) throws UaException {
        PropertyTypeNode node = this.getAccessHistoryDataCapabilityNode();
        node.setValue(new Variant((Object)accessHistoryDataCapability));
    }

    @Override
    public Boolean readAccessHistoryDataCapability() throws UaException {
        try {
            return this.readAccessHistoryDataCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAccessHistoryDataCapability(Boolean accessHistoryDataCapability) throws UaException {
        try {
            this.writeAccessHistoryDataCapabilityAsync(accessHistoryDataCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAccessHistoryDataCapabilityAsync() {
        return ((CompletableFuture)this.getAccessHistoryDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeAccessHistoryDataCapabilityAsync(Boolean accessHistoryDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accessHistoryDataCapability));
        return ((CompletableFuture)this.getAccessHistoryDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getAccessHistoryDataCapabilityNode() throws UaException {
        try {
            return this.getAccessHistoryDataCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAccessHistoryDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AccessHistoryDataCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAccessHistoryEventsCapability() throws UaException {
        PropertyTypeNode node = this.getAccessHistoryEventsCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAccessHistoryEventsCapability(Boolean accessHistoryEventsCapability) throws UaException {
        PropertyTypeNode node = this.getAccessHistoryEventsCapabilityNode();
        node.setValue(new Variant((Object)accessHistoryEventsCapability));
    }

    @Override
    public Boolean readAccessHistoryEventsCapability() throws UaException {
        try {
            return this.readAccessHistoryEventsCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAccessHistoryEventsCapability(Boolean accessHistoryEventsCapability) throws UaException {
        try {
            this.writeAccessHistoryEventsCapabilityAsync(accessHistoryEventsCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAccessHistoryEventsCapabilityAsync() {
        return ((CompletableFuture)this.getAccessHistoryEventsCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeAccessHistoryEventsCapabilityAsync(Boolean accessHistoryEventsCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accessHistoryEventsCapability));
        return ((CompletableFuture)this.getAccessHistoryEventsCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getAccessHistoryEventsCapabilityNode() throws UaException {
        try {
            return this.getAccessHistoryEventsCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAccessHistoryEventsCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AccessHistoryEventsCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxReturnDataValues() throws UaException {
        PropertyTypeNode node = this.getMaxReturnDataValuesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxReturnDataValues(UInteger maxReturnDataValues) throws UaException {
        PropertyTypeNode node = this.getMaxReturnDataValuesNode();
        node.setValue(new Variant((Object)maxReturnDataValues));
    }

    @Override
    public UInteger readMaxReturnDataValues() throws UaException {
        try {
            return this.readMaxReturnDataValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxReturnDataValues(UInteger maxReturnDataValues) throws UaException {
        try {
            this.writeMaxReturnDataValuesAsync(maxReturnDataValues).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxReturnDataValuesAsync() {
        return ((CompletableFuture)this.getMaxReturnDataValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxReturnDataValuesAsync(UInteger maxReturnDataValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxReturnDataValues));
        return ((CompletableFuture)this.getMaxReturnDataValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxReturnDataValuesNode() throws UaException {
        try {
            return this.getMaxReturnDataValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxReturnDataValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxReturnDataValues", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxReturnEventValues() throws UaException {
        PropertyTypeNode node = this.getMaxReturnEventValuesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxReturnEventValues(UInteger maxReturnEventValues) throws UaException {
        PropertyTypeNode node = this.getMaxReturnEventValuesNode();
        node.setValue(new Variant((Object)maxReturnEventValues));
    }

    @Override
    public UInteger readMaxReturnEventValues() throws UaException {
        try {
            return this.readMaxReturnEventValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxReturnEventValues(UInteger maxReturnEventValues) throws UaException {
        try {
            this.writeMaxReturnEventValuesAsync(maxReturnEventValues).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxReturnEventValuesAsync() {
        return ((CompletableFuture)this.getMaxReturnEventValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxReturnEventValuesAsync(UInteger maxReturnEventValues) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxReturnEventValues));
        return ((CompletableFuture)this.getMaxReturnEventValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxReturnEventValuesNode() throws UaException {
        try {
            return this.getMaxReturnEventValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxReturnEventValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxReturnEventValues", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertDataCapability() throws UaException {
        PropertyTypeNode node = this.getInsertDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertDataCapability(Boolean insertDataCapability) throws UaException {
        PropertyTypeNode node = this.getInsertDataCapabilityNode();
        node.setValue(new Variant((Object)insertDataCapability));
    }

    @Override
    public Boolean readInsertDataCapability() throws UaException {
        try {
            return this.readInsertDataCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInsertDataCapability(Boolean insertDataCapability) throws UaException {
        try {
            this.writeInsertDataCapabilityAsync(insertDataCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertDataCapabilityAsync() {
        return ((CompletableFuture)this.getInsertDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeInsertDataCapabilityAsync(Boolean insertDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertDataCapability));
        return ((CompletableFuture)this.getInsertDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getInsertDataCapabilityNode() throws UaException {
        try {
            return this.getInsertDataCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertDataCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getReplaceDataCapability() throws UaException {
        PropertyTypeNode node = this.getReplaceDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setReplaceDataCapability(Boolean replaceDataCapability) throws UaException {
        PropertyTypeNode node = this.getReplaceDataCapabilityNode();
        node.setValue(new Variant((Object)replaceDataCapability));
    }

    @Override
    public Boolean readReplaceDataCapability() throws UaException {
        try {
            return this.readReplaceDataCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReplaceDataCapability(Boolean replaceDataCapability) throws UaException {
        try {
            this.writeReplaceDataCapabilityAsync(replaceDataCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readReplaceDataCapabilityAsync() {
        return ((CompletableFuture)this.getReplaceDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeReplaceDataCapabilityAsync(Boolean replaceDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)replaceDataCapability));
        return ((CompletableFuture)this.getReplaceDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getReplaceDataCapabilityNode() throws UaException {
        try {
            return this.getReplaceDataCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReplaceDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReplaceDataCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUpdateDataCapability() throws UaException {
        PropertyTypeNode node = this.getUpdateDataCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdateDataCapability(Boolean updateDataCapability) throws UaException {
        PropertyTypeNode node = this.getUpdateDataCapabilityNode();
        node.setValue(new Variant((Object)updateDataCapability));
    }

    @Override
    public Boolean readUpdateDataCapability() throws UaException {
        try {
            return this.readUpdateDataCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUpdateDataCapability(Boolean updateDataCapability) throws UaException {
        try {
            this.writeUpdateDataCapabilityAsync(updateDataCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUpdateDataCapabilityAsync() {
        return ((CompletableFuture)this.getUpdateDataCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeUpdateDataCapabilityAsync(Boolean updateDataCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updateDataCapability));
        return ((CompletableFuture)this.getUpdateDataCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getUpdateDataCapabilityNode() throws UaException {
        try {
            return this.getUpdateDataCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdateDataCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdateDataCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteRawCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteRawCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteRawCapability(Boolean deleteRawCapability) throws UaException {
        PropertyTypeNode node = this.getDeleteRawCapabilityNode();
        node.setValue(new Variant((Object)deleteRawCapability));
    }

    @Override
    public Boolean readDeleteRawCapability() throws UaException {
        try {
            return this.readDeleteRawCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteRawCapability(Boolean deleteRawCapability) throws UaException {
        try {
            this.writeDeleteRawCapabilityAsync(deleteRawCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteRawCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteRawCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDeleteRawCapabilityAsync(Boolean deleteRawCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteRawCapability));
        return ((CompletableFuture)this.getDeleteRawCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getDeleteRawCapabilityNode() throws UaException {
        try {
            return this.getDeleteRawCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteRawCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteRawCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteAtTimeCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteAtTimeCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteAtTimeCapability(Boolean deleteAtTimeCapability) throws UaException {
        PropertyTypeNode node = this.getDeleteAtTimeCapabilityNode();
        node.setValue(new Variant((Object)deleteAtTimeCapability));
    }

    @Override
    public Boolean readDeleteAtTimeCapability() throws UaException {
        try {
            return this.readDeleteAtTimeCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteAtTimeCapability(Boolean deleteAtTimeCapability) throws UaException {
        try {
            this.writeDeleteAtTimeCapabilityAsync(deleteAtTimeCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteAtTimeCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteAtTimeCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDeleteAtTimeCapabilityAsync(Boolean deleteAtTimeCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteAtTimeCapability));
        return ((CompletableFuture)this.getDeleteAtTimeCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getDeleteAtTimeCapabilityNode() throws UaException {
        try {
            return this.getDeleteAtTimeCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteAtTimeCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteAtTimeCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertEventCapability() throws UaException {
        PropertyTypeNode node = this.getInsertEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertEventCapability(Boolean insertEventCapability) throws UaException {
        PropertyTypeNode node = this.getInsertEventCapabilityNode();
        node.setValue(new Variant((Object)insertEventCapability));
    }

    @Override
    public Boolean readInsertEventCapability() throws UaException {
        try {
            return this.readInsertEventCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInsertEventCapability(Boolean insertEventCapability) throws UaException {
        try {
            this.writeInsertEventCapabilityAsync(insertEventCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertEventCapabilityAsync() {
        return ((CompletableFuture)this.getInsertEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeInsertEventCapabilityAsync(Boolean insertEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertEventCapability));
        return ((CompletableFuture)this.getInsertEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getInsertEventCapabilityNode() throws UaException {
        try {
            return this.getInsertEventCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertEventCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getReplaceEventCapability() throws UaException {
        PropertyTypeNode node = this.getReplaceEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setReplaceEventCapability(Boolean replaceEventCapability) throws UaException {
        PropertyTypeNode node = this.getReplaceEventCapabilityNode();
        node.setValue(new Variant((Object)replaceEventCapability));
    }

    @Override
    public Boolean readReplaceEventCapability() throws UaException {
        try {
            return this.readReplaceEventCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReplaceEventCapability(Boolean replaceEventCapability) throws UaException {
        try {
            this.writeReplaceEventCapabilityAsync(replaceEventCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readReplaceEventCapabilityAsync() {
        return ((CompletableFuture)this.getReplaceEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeReplaceEventCapabilityAsync(Boolean replaceEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)replaceEventCapability));
        return ((CompletableFuture)this.getReplaceEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getReplaceEventCapabilityNode() throws UaException {
        try {
            return this.getReplaceEventCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReplaceEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReplaceEventCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUpdateEventCapability() throws UaException {
        PropertyTypeNode node = this.getUpdateEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUpdateEventCapability(Boolean updateEventCapability) throws UaException {
        PropertyTypeNode node = this.getUpdateEventCapabilityNode();
        node.setValue(new Variant((Object)updateEventCapability));
    }

    @Override
    public Boolean readUpdateEventCapability() throws UaException {
        try {
            return this.readUpdateEventCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUpdateEventCapability(Boolean updateEventCapability) throws UaException {
        try {
            this.writeUpdateEventCapabilityAsync(updateEventCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUpdateEventCapabilityAsync() {
        return ((CompletableFuture)this.getUpdateEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeUpdateEventCapabilityAsync(Boolean updateEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)updateEventCapability));
        return ((CompletableFuture)this.getUpdateEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getUpdateEventCapabilityNode() throws UaException {
        try {
            return this.getUpdateEventCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUpdateEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UpdateEventCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeleteEventCapability() throws UaException {
        PropertyTypeNode node = this.getDeleteEventCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeleteEventCapability(Boolean deleteEventCapability) throws UaException {
        PropertyTypeNode node = this.getDeleteEventCapabilityNode();
        node.setValue(new Variant((Object)deleteEventCapability));
    }

    @Override
    public Boolean readDeleteEventCapability() throws UaException {
        try {
            return this.readDeleteEventCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteEventCapability(Boolean deleteEventCapability) throws UaException {
        try {
            this.writeDeleteEventCapabilityAsync(deleteEventCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeleteEventCapabilityAsync() {
        return ((CompletableFuture)this.getDeleteEventCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDeleteEventCapabilityAsync(Boolean deleteEventCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deleteEventCapability));
        return ((CompletableFuture)this.getDeleteEventCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getDeleteEventCapabilityNode() throws UaException {
        try {
            return this.getDeleteEventCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeleteEventCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteEventCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getInsertAnnotationCapability() throws UaException {
        PropertyTypeNode node = this.getInsertAnnotationCapabilityNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setInsertAnnotationCapability(Boolean insertAnnotationCapability) throws UaException {
        PropertyTypeNode node = this.getInsertAnnotationCapabilityNode();
        node.setValue(new Variant((Object)insertAnnotationCapability));
    }

    @Override
    public Boolean readInsertAnnotationCapability() throws UaException {
        try {
            return this.readInsertAnnotationCapabilityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInsertAnnotationCapability(Boolean insertAnnotationCapability) throws UaException {
        try {
            this.writeInsertAnnotationCapabilityAsync(insertAnnotationCapability).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readInsertAnnotationCapabilityAsync() {
        return ((CompletableFuture)this.getInsertAnnotationCapabilityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeInsertAnnotationCapabilityAsync(Boolean insertAnnotationCapability) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)insertAnnotationCapability));
        return ((CompletableFuture)this.getInsertAnnotationCapabilityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getInsertAnnotationCapabilityNode() throws UaException {
        try {
            return this.getInsertAnnotationCapabilityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInsertAnnotationCapabilityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InsertAnnotationCapability", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public FolderTypeNode getAggregateFunctionsNode() throws UaException {
        try {
            return this.getAggregateFunctionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getAggregateFunctionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateFunctions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

