/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.LimitAlarmTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.NonExclusiveLimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class NonExclusiveLimitAlarmTypeNode
extends LimitAlarmTypeNode
implements NonExclusiveLimitAlarmType {
    public NonExclusiveLimitAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getActiveState() throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setActiveState(LocalizedText activeState) throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        node.setValue(new Variant((Object)activeState));
    }

    @Override
    public LocalizedText readActiveState() throws UaException {
        try {
            return this.readActiveStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActiveState(LocalizedText activeState) throws UaException {
        try {
            this.writeActiveStateAsync(activeState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readActiveStateAsync() {
        return ((CompletableFuture)this.getActiveStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeActiveStateAsync(LocalizedText activeState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)activeState));
        return ((CompletableFuture)this.getActiveStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getActiveStateNode() throws UaException {
        try {
            return this.getActiveStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getActiveStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActiveState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getHighHighState() throws UaException {
        TwoStateVariableTypeNode node = this.getHighHighStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighHighState(LocalizedText highHighState) throws UaException {
        TwoStateVariableTypeNode node = this.getHighHighStateNode();
        node.setValue(new Variant((Object)highHighState));
    }

    @Override
    public LocalizedText readHighHighState() throws UaException {
        try {
            return this.readHighHighStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHighHighState(LocalizedText highHighState) throws UaException {
        try {
            this.writeHighHighStateAsync(highHighState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readHighHighStateAsync() {
        return ((CompletableFuture)this.getHighHighStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeHighHighStateAsync(LocalizedText highHighState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highHighState));
        return ((CompletableFuture)this.getHighHighStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getHighHighStateNode() throws UaException {
        try {
            return this.getHighHighStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getHighHighStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighHighState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getHighState() throws UaException {
        TwoStateVariableTypeNode node = this.getHighStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighState(LocalizedText highState) throws UaException {
        TwoStateVariableTypeNode node = this.getHighStateNode();
        node.setValue(new Variant((Object)highState));
    }

    @Override
    public LocalizedText readHighState() throws UaException {
        try {
            return this.readHighStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHighState(LocalizedText highState) throws UaException {
        try {
            this.writeHighStateAsync(highState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readHighStateAsync() {
        return ((CompletableFuture)this.getHighStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeHighStateAsync(LocalizedText highState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highState));
        return ((CompletableFuture)this.getHighStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getHighStateNode() throws UaException {
        try {
            return this.getHighStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getHighStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLowState() throws UaException {
        TwoStateVariableTypeNode node = this.getLowStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowState(LocalizedText lowState) throws UaException {
        TwoStateVariableTypeNode node = this.getLowStateNode();
        node.setValue(new Variant((Object)lowState));
    }

    @Override
    public LocalizedText readLowState() throws UaException {
        try {
            return this.readLowStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLowState(LocalizedText lowState) throws UaException {
        try {
            this.writeLowStateAsync(lowState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLowStateAsync() {
        return ((CompletableFuture)this.getLowStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeLowStateAsync(LocalizedText lowState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowState));
        return ((CompletableFuture)this.getLowStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getLowStateNode() throws UaException {
        try {
            return this.getLowStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getLowStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLowLowState() throws UaException {
        TwoStateVariableTypeNode node = this.getLowLowStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLowState(LocalizedText lowLowState) throws UaException {
        TwoStateVariableTypeNode node = this.getLowLowStateNode();
        node.setValue(new Variant((Object)lowLowState));
    }

    @Override
    public LocalizedText readLowLowState() throws UaException {
        try {
            return this.readLowLowStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLowLowState(LocalizedText lowLowState) throws UaException {
        try {
            this.writeLowLowStateAsync(lowLowState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLowLowStateAsync() {
        return ((CompletableFuture)this.getLowLowStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeLowLowStateAsync(LocalizedText lowLowState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLowState));
        return ((CompletableFuture)this.getLowLowStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public TwoStateVariableTypeNode getLowLowStateNode() throws UaException {
        try {
            return this.getLowLowStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getLowLowStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLowState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }
}

