/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ProgramDiagnosticTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ProgramStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    public ProgramStateMachineTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Boolean getCreatable() throws UaException {
        PropertyTypeNode node = this.getCreatableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setCreatable(Boolean creatable) throws UaException {
        PropertyTypeNode node = this.getCreatableNode();
        node.setValue(new Variant((Object)creatable));
    }

    @Override
    public Boolean readCreatable() throws UaException {
        try {
            return this.readCreatableAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCreatable(Boolean creatable) throws UaException {
        try {
            this.writeCreatableAsync(creatable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readCreatableAsync() {
        return ((CompletableFuture)this.getCreatableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeCreatableAsync(Boolean creatable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)creatable));
        return ((CompletableFuture)this.getCreatableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getCreatableNode() throws UaException {
        try {
            return this.getCreatableNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCreatableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Creatable", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getDeletable() throws UaException {
        PropertyTypeNode node = this.getDeletableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setDeletable(Boolean deletable) throws UaException {
        PropertyTypeNode node = this.getDeletableNode();
        node.setValue(new Variant((Object)deletable));
    }

    @Override
    public Boolean readDeletable() throws UaException {
        try {
            return this.readDeletableAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeletable(Boolean deletable) throws UaException {
        try {
            this.writeDeletableAsync(deletable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readDeletableAsync() {
        return ((CompletableFuture)this.getDeletableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeDeletableAsync(Boolean deletable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)deletable));
        return ((CompletableFuture)this.getDeletableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getDeletableNode() throws UaException {
        try {
            return this.getDeletableNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDeletableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Deletable", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAutoDelete() throws UaException {
        PropertyTypeNode node = this.getAutoDeleteNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAutoDelete(Boolean autoDelete) throws UaException {
        PropertyTypeNode node = this.getAutoDeleteNode();
        node.setValue(new Variant((Object)autoDelete));
    }

    @Override
    public Boolean readAutoDelete() throws UaException {
        try {
            return this.readAutoDeleteAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAutoDelete(Boolean autoDelete) throws UaException {
        try {
            this.writeAutoDeleteAsync(autoDelete).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAutoDeleteAsync() {
        return ((CompletableFuture)this.getAutoDeleteNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeAutoDeleteAsync(Boolean autoDelete) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)autoDelete));
        return ((CompletableFuture)this.getAutoDeleteNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getAutoDeleteNode() throws UaException {
        try {
            return this.getAutoDeleteNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAutoDeleteNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AutoDelete", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Integer getRecycleCount() throws UaException {
        PropertyTypeNode node = this.getRecycleCountNode();
        return (Integer)node.getValue().getValue().getValue();
    }

    @Override
    public void setRecycleCount(Integer recycleCount) throws UaException {
        PropertyTypeNode node = this.getRecycleCountNode();
        node.setValue(new Variant((Object)recycleCount));
    }

    @Override
    public Integer readRecycleCount() throws UaException {
        try {
            return this.readRecycleCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRecycleCount(Integer recycleCount) throws UaException {
        try {
            this.writeRecycleCountAsync(recycleCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Integer> readRecycleCountAsync() {
        return ((CompletableFuture)this.getRecycleCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Integer)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeRecycleCountAsync(Integer recycleCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)recycleCount));
        return ((CompletableFuture)this.getRecycleCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getRecycleCountNode() throws UaException {
        try {
            return this.getRecycleCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRecycleCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RecycleCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getInstanceCount() throws UaException {
        PropertyTypeNode node = this.getInstanceCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setInstanceCount(UInteger instanceCount) throws UaException {
        PropertyTypeNode node = this.getInstanceCountNode();
        node.setValue(new Variant((Object)instanceCount));
    }

    @Override
    public UInteger readInstanceCount() throws UaException {
        try {
            return this.readInstanceCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInstanceCount(UInteger instanceCount) throws UaException {
        try {
            this.writeInstanceCountAsync(instanceCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readInstanceCountAsync() {
        return ((CompletableFuture)this.getInstanceCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeInstanceCountAsync(UInteger instanceCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)instanceCount));
        return ((CompletableFuture)this.getInstanceCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getInstanceCountNode() throws UaException {
        try {
            return this.getInstanceCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInstanceCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InstanceCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxInstanceCount() throws UaException {
        PropertyTypeNode node = this.getMaxInstanceCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxInstanceCount(UInteger maxInstanceCount) throws UaException {
        PropertyTypeNode node = this.getMaxInstanceCountNode();
        node.setValue(new Variant((Object)maxInstanceCount));
    }

    @Override
    public UInteger readMaxInstanceCount() throws UaException {
        try {
            return this.readMaxInstanceCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxInstanceCount(UInteger maxInstanceCount) throws UaException {
        try {
            this.writeMaxInstanceCountAsync(maxInstanceCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxInstanceCountAsync() {
        return ((CompletableFuture)this.getMaxInstanceCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxInstanceCountAsync(UInteger maxInstanceCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxInstanceCount));
        return ((CompletableFuture)this.getMaxInstanceCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxInstanceCountNode() throws UaException {
        try {
            return this.getMaxInstanceCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxInstanceCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxInstanceCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxRecycleCount() throws UaException {
        PropertyTypeNode node = this.getMaxRecycleCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxRecycleCount(UInteger maxRecycleCount) throws UaException {
        PropertyTypeNode node = this.getMaxRecycleCountNode();
        node.setValue(new Variant((Object)maxRecycleCount));
    }

    @Override
    public UInteger readMaxRecycleCount() throws UaException {
        try {
            return this.readMaxRecycleCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxRecycleCount(UInteger maxRecycleCount) throws UaException {
        try {
            this.writeMaxRecycleCountAsync(maxRecycleCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxRecycleCountAsync() {
        return ((CompletableFuture)this.getMaxRecycleCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxRecycleCountAsync(UInteger maxRecycleCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxRecycleCount));
        return ((CompletableFuture)this.getMaxRecycleCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxRecycleCountNode() throws UaException {
        try {
            return this.getMaxRecycleCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxRecycleCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxRecycleCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getCurrentState() throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentState(LocalizedText currentState) throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        node.setValue(new Variant((Object)currentState));
    }

    @Override
    public LocalizedText readCurrentState() throws UaException {
        try {
            return this.readCurrentStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentState(LocalizedText currentState) throws UaException {
        try {
            this.writeCurrentStateAsync(currentState).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCurrentStateAsync() {
        return ((CompletableFuture)this.getCurrentStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeCurrentStateAsync(LocalizedText currentState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentState));
        return ((CompletableFuture)this.getCurrentStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public FiniteStateVariableTypeNode getCurrentStateNode() throws UaException {
        try {
            return this.getCurrentStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends FiniteStateVariableTypeNode> getCurrentStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentState", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (FiniteStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLastTransition() throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastTransition(LocalizedText lastTransition) throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        node.setValue(new Variant((Object)lastTransition));
    }

    @Override
    public LocalizedText readLastTransition() throws UaException {
        try {
            return this.readLastTransitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastTransition(LocalizedText lastTransition) throws UaException {
        try {
            this.writeLastTransitionAsync(lastTransition).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLastTransitionAsync() {
        return ((CompletableFuture)this.getLastTransitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeLastTransitionAsync(LocalizedText lastTransition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastTransition));
        return ((CompletableFuture)this.getLastTransitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public FiniteTransitionVariableTypeNode getLastTransitionNode() throws UaException {
        try {
            return this.getLastTransitionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends FiniteTransitionVariableTypeNode> getLastTransitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastTransition", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (FiniteTransitionVariableTypeNode)node);
    }

    @Override
    public ProgramDiagnosticDataType getProgramDiagnostics() throws UaException {
        ProgramDiagnosticTypeNode node = this.getProgramDiagnosticsNode();
        return this.cast(node.getValue().getValue().getValue(), ProgramDiagnosticDataType.class);
    }

    @Override
    public void setProgramDiagnostics(ProgramDiagnosticDataType programDiagnostics) throws UaException {
        ProgramDiagnosticTypeNode node = this.getProgramDiagnosticsNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)programDiagnostics);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ProgramDiagnosticDataType readProgramDiagnostics() throws UaException {
        try {
            return this.readProgramDiagnosticsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProgramDiagnostics(ProgramDiagnosticDataType programDiagnostics) throws UaException {
        try {
            this.writeProgramDiagnosticsAsync(programDiagnostics).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ProgramDiagnosticDataType> readProgramDiagnosticsAsync() {
        return ((CompletableFuture)this.getProgramDiagnosticsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ProgramDiagnosticDataType.class));
    }

    @Override
    public CompletableFuture<Unit> writeProgramDiagnosticsAsync(ProgramDiagnosticDataType programDiagnostics) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)programDiagnostics);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getProgramDiagnosticsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public ProgramDiagnosticTypeNode getProgramDiagnosticsNode() throws UaException {
        try {
            return this.getProgramDiagnosticsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends ProgramDiagnosticTypeNode> getProgramDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProgramDiagnostics", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (ProgramDiagnosticTypeNode)node);
    }

    @Override
    public BaseObjectTypeNode getFinalResultDataNode() throws UaException {
        try {
            return this.getFinalResultDataNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseObjectTypeNode> getFinalResultDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FinalResultData", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseObjectTypeNode)node);
    }

    @Override
    public StateTypeNode getReadyNode() throws UaException {
        try {
            return this.getReadyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Ready", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getRunningNode() throws UaException {
        try {
            return this.getRunningNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Running", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getSuspendedNode() throws UaException {
        try {
            return this.getSuspendedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getSuspendedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Suspended", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getHaltedNode() throws UaException {
        try {
            return this.getHaltedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Halted", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public TransitionTypeNode getHaltedToReadyNode() throws UaException {
        try {
            return this.getHaltedToReadyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getHaltedToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HaltedToReady", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getReadyToRunningNode() throws UaException {
        try {
            return this.getReadyToRunningNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getReadyToRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReadyToRunning", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToHaltedNode() throws UaException {
        try {
            return this.getRunningToHaltedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToHalted", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToReadyNode() throws UaException {
        try {
            return this.getRunningToReadyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToReady", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getRunningToSuspendedNode() throws UaException {
        try {
            return this.getRunningToSuspendedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getRunningToSuspendedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RunningToSuspended", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToRunningNode() throws UaException {
        try {
            return this.getSuspendedToRunningNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToRunningNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToRunning", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToHaltedNode() throws UaException {
        try {
            return this.getSuspendedToHaltedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToHalted", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getSuspendedToReadyNode() throws UaException {
        try {
            return this.getSuspendedToReadyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getSuspendedToReadyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuspendedToReady", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getReadyToHaltedNode() throws UaException {
        try {
            return this.getReadyToHaltedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getReadyToHaltedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReadyToHalted", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }
}

