/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.OperationLimitsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerCapabilitiesType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ServerCapabilitiesTypeNode
extends BaseObjectTypeNode
implements ServerCapabilitiesType {
    public ServerCapabilitiesTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public String[] getServerProfileArray() throws UaException {
        PropertyTypeNode node = this.getServerProfileArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setServerProfileArray(String[] serverProfileArray) throws UaException {
        PropertyTypeNode node = this.getServerProfileArrayNode();
        node.setValue(new Variant((Object)serverProfileArray));
    }

    @Override
    public String[] readServerProfileArray() throws UaException {
        try {
            return this.readServerProfileArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerProfileArray(String[] serverProfileArray) throws UaException {
        try {
            this.writeServerProfileArrayAsync(serverProfileArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readServerProfileArrayAsync() {
        return ((CompletableFuture)this.getServerProfileArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeServerProfileArrayAsync(String[] serverProfileArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverProfileArray));
        return ((CompletableFuture)this.getServerProfileArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getServerProfileArrayNode() throws UaException {
        try {
            return this.getServerProfileArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerProfileArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerProfileArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getLocaleIdArray() throws UaException {
        PropertyTypeNode node = this.getLocaleIdArrayNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLocaleIdArray(String[] localeIdArray) throws UaException {
        PropertyTypeNode node = this.getLocaleIdArrayNode();
        node.setValue(new Variant((Object)localeIdArray));
    }

    @Override
    public String[] readLocaleIdArray() throws UaException {
        try {
            return this.readLocaleIdArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLocaleIdArray(String[] localeIdArray) throws UaException {
        try {
            this.writeLocaleIdArrayAsync(localeIdArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readLocaleIdArrayAsync() {
        return ((CompletableFuture)this.getLocaleIdArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeLocaleIdArrayAsync(String[] localeIdArray) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)localeIdArray));
        return ((CompletableFuture)this.getLocaleIdArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getLocaleIdArrayNode() throws UaException {
        try {
            return this.getLocaleIdArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLocaleIdArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocaleIdArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMinSupportedSampleRate() throws UaException {
        PropertyTypeNode node = this.getMinSupportedSampleRateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMinSupportedSampleRate(Double minSupportedSampleRate) throws UaException {
        PropertyTypeNode node = this.getMinSupportedSampleRateNode();
        node.setValue(new Variant((Object)minSupportedSampleRate));
    }

    @Override
    public Double readMinSupportedSampleRate() throws UaException {
        try {
            return this.readMinSupportedSampleRateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMinSupportedSampleRate(Double minSupportedSampleRate) throws UaException {
        try {
            this.writeMinSupportedSampleRateAsync(minSupportedSampleRate).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMinSupportedSampleRateAsync() {
        return ((CompletableFuture)this.getMinSupportedSampleRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMinSupportedSampleRateAsync(Double minSupportedSampleRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)minSupportedSampleRate));
        return ((CompletableFuture)this.getMinSupportedSampleRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMinSupportedSampleRateNode() throws UaException {
        try {
            return this.getMinSupportedSampleRateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMinSupportedSampleRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MinSupportedSampleRate", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxBrowseContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxBrowseContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxBrowseContinuationPoints(UShort maxBrowseContinuationPoints) throws UaException {
        PropertyTypeNode node = this.getMaxBrowseContinuationPointsNode();
        node.setValue(new Variant((Object)maxBrowseContinuationPoints));
    }

    @Override
    public UShort readMaxBrowseContinuationPoints() throws UaException {
        try {
            return this.readMaxBrowseContinuationPointsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxBrowseContinuationPoints(UShort maxBrowseContinuationPoints) throws UaException {
        try {
            this.writeMaxBrowseContinuationPointsAsync(maxBrowseContinuationPoints).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxBrowseContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxBrowseContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxBrowseContinuationPointsAsync(UShort maxBrowseContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxBrowseContinuationPoints));
        return ((CompletableFuture)this.getMaxBrowseContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxBrowseContinuationPointsNode() throws UaException {
        try {
            return this.getMaxBrowseContinuationPointsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxBrowseContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxQueryContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxQueryContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxQueryContinuationPoints(UShort maxQueryContinuationPoints) throws UaException {
        PropertyTypeNode node = this.getMaxQueryContinuationPointsNode();
        node.setValue(new Variant((Object)maxQueryContinuationPoints));
    }

    @Override
    public UShort readMaxQueryContinuationPoints() throws UaException {
        try {
            return this.readMaxQueryContinuationPointsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxQueryContinuationPoints(UShort maxQueryContinuationPoints) throws UaException {
        try {
            this.writeMaxQueryContinuationPointsAsync(maxQueryContinuationPoints).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxQueryContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxQueryContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxQueryContinuationPointsAsync(UShort maxQueryContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxQueryContinuationPoints));
        return ((CompletableFuture)this.getMaxQueryContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxQueryContinuationPointsNode() throws UaException {
        try {
            return this.getMaxQueryContinuationPointsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxQueryContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getMaxHistoryContinuationPoints() throws UaException {
        PropertyTypeNode node = this.getMaxHistoryContinuationPointsNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxHistoryContinuationPoints(UShort maxHistoryContinuationPoints) throws UaException {
        PropertyTypeNode node = this.getMaxHistoryContinuationPointsNode();
        node.setValue(new Variant((Object)maxHistoryContinuationPoints));
    }

    @Override
    public UShort readMaxHistoryContinuationPoints() throws UaException {
        try {
            return this.readMaxHistoryContinuationPointsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxHistoryContinuationPoints(UShort maxHistoryContinuationPoints) throws UaException {
        try {
            this.writeMaxHistoryContinuationPointsAsync(maxHistoryContinuationPoints).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxHistoryContinuationPointsAsync() {
        return ((CompletableFuture)this.getMaxHistoryContinuationPointsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxHistoryContinuationPointsAsync(UShort maxHistoryContinuationPoints) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxHistoryContinuationPoints));
        return ((CompletableFuture)this.getMaxHistoryContinuationPointsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxHistoryContinuationPointsNode() throws UaException {
        try {
            return this.getMaxHistoryContinuationPointsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxHistoryContinuationPointsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SignedSoftwareCertificate[] getSoftwareCertificates() throws UaException {
        PropertyTypeNode node = this.getSoftwareCertificatesNode();
        return this.cast(node.getValue().getValue().getValue(), SignedSoftwareCertificate[].class);
    }

    @Override
    public void setSoftwareCertificates(SignedSoftwareCertificate[] softwareCertificates) throws UaException {
        PropertyTypeNode node = this.getSoftwareCertificatesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])softwareCertificates);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SignedSoftwareCertificate[] readSoftwareCertificates() throws UaException {
        try {
            return this.readSoftwareCertificatesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSoftwareCertificates(SignedSoftwareCertificate[] softwareCertificates) throws UaException {
        try {
            this.writeSoftwareCertificatesAsync(softwareCertificates).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SignedSoftwareCertificate[]> readSoftwareCertificatesAsync() {
        return ((CompletableFuture)this.getSoftwareCertificatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SignedSoftwareCertificate[].class));
    }

    @Override
    public CompletableFuture<Unit> writeSoftwareCertificatesAsync(SignedSoftwareCertificate[] softwareCertificates) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])softwareCertificates);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getSoftwareCertificatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getSoftwareCertificatesNode() throws UaException {
        try {
            return this.getSoftwareCertificatesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSoftwareCertificatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SoftwareCertificates", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxArrayLength() throws UaException {
        PropertyTypeNode node = this.getMaxArrayLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxArrayLength(UInteger maxArrayLength) throws UaException {
        PropertyTypeNode node = this.getMaxArrayLengthNode();
        node.setValue(new Variant((Object)maxArrayLength));
    }

    @Override
    public UInteger readMaxArrayLength() throws UaException {
        try {
            return this.readMaxArrayLengthAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxArrayLength(UInteger maxArrayLength) throws UaException {
        try {
            this.writeMaxArrayLengthAsync(maxArrayLength).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxArrayLengthAsync() {
        return ((CompletableFuture)this.getMaxArrayLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxArrayLengthAsync(UInteger maxArrayLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxArrayLength));
        return ((CompletableFuture)this.getMaxArrayLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxArrayLengthNode() throws UaException {
        try {
            return this.getMaxArrayLengthNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxArrayLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxArrayLength", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxStringLength() throws UaException {
        PropertyTypeNode node = this.getMaxStringLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxStringLength(UInteger maxStringLength) throws UaException {
        PropertyTypeNode node = this.getMaxStringLengthNode();
        node.setValue(new Variant((Object)maxStringLength));
    }

    @Override
    public UInteger readMaxStringLength() throws UaException {
        try {
            return this.readMaxStringLengthAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxStringLength(UInteger maxStringLength) throws UaException {
        try {
            this.writeMaxStringLengthAsync(maxStringLength).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxStringLengthAsync() {
        return ((CompletableFuture)this.getMaxStringLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxStringLengthAsync(UInteger maxStringLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxStringLength));
        return ((CompletableFuture)this.getMaxStringLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxStringLengthNode() throws UaException {
        try {
            return this.getMaxStringLengthNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxStringLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxStringLength", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxByteStringLength() throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxByteStringLength(UInteger maxByteStringLength) throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        node.setValue(new Variant((Object)maxByteStringLength));
    }

    @Override
    public UInteger readMaxByteStringLength() throws UaException {
        try {
            return this.readMaxByteStringLengthAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxByteStringLength(UInteger maxByteStringLength) throws UaException {
        try {
            this.writeMaxByteStringLengthAsync(maxByteStringLength).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxByteStringLengthAsync() {
        return ((CompletableFuture)this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeMaxByteStringLengthAsync(UInteger maxByteStringLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxByteStringLength));
        return ((CompletableFuture)this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getMaxByteStringLengthNode() throws UaException {
        try {
            return this.getMaxByteStringLengthNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxByteStringLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxByteStringLength", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public OperationLimitsTypeNode getOperationLimitsNode() throws UaException {
        try {
            return this.getOperationLimitsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends OperationLimitsTypeNode> getOperationLimitsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OperationLimits", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (OperationLimitsTypeNode)node);
    }

    @Override
    public FolderTypeNode getModellingRulesNode() throws UaException {
        try {
            return this.getModellingRulesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getModellingRulesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModellingRules", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }

    @Override
    public FolderTypeNode getAggregateFunctionsNode() throws UaException {
        try {
            return this.getAggregateFunctionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getAggregateFunctionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AggregateFunctions", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

