/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SessionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SessionSecurityDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.SessionsDiagnosticsSummaryType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionSecurityDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class SessionsDiagnosticsSummaryTypeNode
extends BaseObjectTypeNode
implements SessionsDiagnosticsSummaryType {
    public SessionsDiagnosticsSummaryTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public SessionDiagnosticsDataType[] getSessionDiagnosticsArray() throws UaException {
        SessionDiagnosticsArrayTypeNode node = this.getSessionDiagnosticsArrayNode();
        return this.cast(node.getValue().getValue().getValue(), SessionDiagnosticsDataType[].class);
    }

    @Override
    public void setSessionDiagnosticsArray(SessionDiagnosticsDataType[] sessionDiagnosticsArray) throws UaException {
        SessionDiagnosticsArrayTypeNode node = this.getSessionDiagnosticsArrayNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])sessionDiagnosticsArray);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SessionDiagnosticsDataType[] readSessionDiagnosticsArray() throws UaException {
        try {
            return this.readSessionDiagnosticsArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionDiagnosticsArray(SessionDiagnosticsDataType[] sessionDiagnosticsArray) throws UaException {
        try {
            this.writeSessionDiagnosticsArrayAsync(sessionDiagnosticsArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SessionDiagnosticsDataType[]> readSessionDiagnosticsArrayAsync() {
        return ((CompletableFuture)this.getSessionDiagnosticsArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SessionDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<Unit> writeSessionDiagnosticsArrayAsync(SessionDiagnosticsDataType[] sessionDiagnosticsArray) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])sessionDiagnosticsArray);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getSessionDiagnosticsArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public SessionDiagnosticsArrayTypeNode getSessionDiagnosticsArrayNode() throws UaException {
        try {
            return this.getSessionDiagnosticsArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends SessionDiagnosticsArrayTypeNode> getSessionDiagnosticsArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionDiagnosticsArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (SessionDiagnosticsArrayTypeNode)node);
    }

    @Override
    public SessionSecurityDiagnosticsDataType[] getSessionSecurityDiagnosticsArray() throws UaException {
        SessionSecurityDiagnosticsArrayTypeNode node = this.getSessionSecurityDiagnosticsArrayNode();
        return this.cast(node.getValue().getValue().getValue(), SessionSecurityDiagnosticsDataType[].class);
    }

    @Override
    public void setSessionSecurityDiagnosticsArray(SessionSecurityDiagnosticsDataType[] sessionSecurityDiagnosticsArray) throws UaException {
        SessionSecurityDiagnosticsArrayTypeNode node = this.getSessionSecurityDiagnosticsArrayNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])sessionSecurityDiagnosticsArray);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SessionSecurityDiagnosticsDataType[] readSessionSecurityDiagnosticsArray() throws UaException {
        try {
            return this.readSessionSecurityDiagnosticsArrayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionSecurityDiagnosticsArray(SessionSecurityDiagnosticsDataType[] sessionSecurityDiagnosticsArray) throws UaException {
        try {
            this.writeSessionSecurityDiagnosticsArrayAsync(sessionSecurityDiagnosticsArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SessionSecurityDiagnosticsDataType[]> readSessionSecurityDiagnosticsArrayAsync() {
        return ((CompletableFuture)this.getSessionSecurityDiagnosticsArrayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SessionSecurityDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<Unit> writeSessionSecurityDiagnosticsArrayAsync(SessionSecurityDiagnosticsDataType[] sessionSecurityDiagnosticsArray) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getSerializationContext(), (UaStructure[])sessionSecurityDiagnosticsArray);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return ((CompletableFuture)this.getSessionSecurityDiagnosticsArrayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public SessionSecurityDiagnosticsArrayTypeNode getSessionSecurityDiagnosticsArrayNode() throws UaException {
        try {
            return this.getSessionSecurityDiagnosticsArrayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends SessionSecurityDiagnosticsArrayTypeNode> getSessionSecurityDiagnosticsArrayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionSecurityDiagnosticsArray", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (SessionSecurityDiagnosticsArrayTypeNode)node);
    }
}

