/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ShelvedStateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ShelvedStateMachineTypeNode
extends FiniteStateMachineTypeNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Double getUnshelveTime() throws UaException {
        PropertyTypeNode node = this.getUnshelveTimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setUnshelveTime(Double unshelveTime) throws UaException {
        PropertyTypeNode node = this.getUnshelveTimeNode();
        node.setValue(new Variant((Object)unshelveTime));
    }

    @Override
    public Double readUnshelveTime() throws UaException {
        try {
            return this.readUnshelveTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUnshelveTime(Double unshelveTime) throws UaException {
        try {
            this.writeUnshelveTimeAsync(unshelveTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readUnshelveTimeAsync() {
        return ((CompletableFuture)this.getUnshelveTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<Unit> writeUnshelveTimeAsync(Double unshelveTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)unshelveTime));
        return ((CompletableFuture)this.getUnshelveTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value))).thenCompose(statusCode -> {
            if (statusCode != null && statusCode.isBad()) {
                return FutureUtils.failedUaFuture((StatusCode)statusCode);
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    @Override
    public PropertyTypeNode getUnshelveTimeNode() throws UaException {
        try {
            return this.getUnshelveTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUnshelveTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnshelveTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public StateTypeNode getUnshelvedNode() throws UaException {
        try {
            return this.getUnshelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getUnshelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Unshelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getTimedShelvedNode() throws UaException {
        try {
            return this.getTimedShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getTimedShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TimedShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public StateTypeNode getOneShotShelvedNode() throws UaException {
        try {
            return this.getOneShotShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends StateTypeNode> getOneShotShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OneShotShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (StateTypeNode)node);
    }

    @Override
    public TransitionTypeNode getUnshelvedToTimedShelvedNode() throws UaException {
        try {
            return this.getUnshelvedToTimedShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getUnshelvedToTimedShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnshelvedToTimedShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getUnshelvedToOneShotShelvedNode() throws UaException {
        try {
            return this.getUnshelvedToOneShotShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getUnshelvedToOneShotShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnshelvedToOneShotShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getTimedShelvedToUnshelvedNode() throws UaException {
        try {
            return this.getTimedShelvedToUnshelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getTimedShelvedToUnshelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TimedShelvedToUnshelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getTimedShelvedToOneShotShelvedNode() throws UaException {
        try {
            return this.getTimedShelvedToOneShotShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getTimedShelvedToOneShotShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TimedShelvedToOneShotShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getOneShotShelvedToUnshelvedNode() throws UaException {
        try {
            return this.getOneShotShelvedToUnshelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getOneShotShelvedToUnshelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OneShotShelvedToUnshelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }

    @Override
    public TransitionTypeNode getOneShotShelvedToTimedShelvedNode() throws UaException {
        try {
            return this.getOneShotShelvedToTimedShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends TransitionTypeNode> getOneShotShelvedToTimedShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OneShotShelvedToTimedShelved", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (TransitionTypeNode)node);
    }
}

