/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.SamplingIntervalDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class SamplingIntervalDiagnosticsTypeNode
extends BaseDataVariableTypeNode
implements SamplingIntervalDiagnosticsType {
    public SamplingIntervalDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, int valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, double minimumSamplingInterval, boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public Double getSamplingInterval() throws UaException {
        BaseDataVariableTypeNode node = this.getSamplingIntervalNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setSamplingInterval(Double samplingInterval) throws UaException {
        BaseDataVariableTypeNode node = this.getSamplingIntervalNode();
        node.setValue(new Variant((Object)samplingInterval));
    }

    @Override
    public Double readSamplingInterval() throws UaException {
        try {
            return this.readSamplingIntervalAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSamplingInterval(Double samplingInterval) throws UaException {
        try {
            this.writeSamplingIntervalAsync(samplingInterval).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readSamplingIntervalAsync() {
        return ((CompletableFuture)this.getSamplingIntervalNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSamplingIntervalAsync(Double samplingInterval) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)samplingInterval));
        return this.getSamplingIntervalNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSamplingIntervalNode() throws UaException {
        try {
            return this.getSamplingIntervalNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSamplingIntervalNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SamplingInterval", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getSampledMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSampledMonitoredItemsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setSampledMonitoredItemsCount(UInteger sampledMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSampledMonitoredItemsCountNode();
        node.setValue(new Variant((Object)sampledMonitoredItemsCount));
    }

    @Override
    public UInteger readSampledMonitoredItemsCount() throws UaException {
        try {
            return this.readSampledMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSampledMonitoredItemsCount(UInteger sampledMonitoredItemsCount) throws UaException {
        try {
            this.writeSampledMonitoredItemsCountAsync(sampledMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readSampledMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSampledMonitoredItemsCountAsync(UInteger sampledMonitoredItemsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sampledMonitoredItemsCount));
        return this.getSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSampledMonitoredItemsCountNode() throws UaException {
        try {
            return this.getSampledMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSampledMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SampledMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxSampledMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxSampledMonitoredItemsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSampledMonitoredItemsCount(UInteger maxSampledMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxSampledMonitoredItemsCountNode();
        node.setValue(new Variant((Object)maxSampledMonitoredItemsCount));
    }

    @Override
    public UInteger readMaxSampledMonitoredItemsCount() throws UaException {
        try {
            return this.readMaxSampledMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxSampledMonitoredItemsCount(UInteger maxSampledMonitoredItemsCount) throws UaException {
        try {
            this.writeMaxSampledMonitoredItemsCountAsync(maxSampledMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSampledMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getMaxSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSampledMonitoredItemsCountAsync(UInteger maxSampledMonitoredItemsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSampledMonitoredItemsCount));
        return this.getMaxSampledMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxSampledMonitoredItemsCountNode() throws UaException {
        try {
            return this.getMaxSampledMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxSampledMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSampledMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getDisabledMonitoredItemsSamplingCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemsSamplingCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setDisabledMonitoredItemsSamplingCount(UInteger disabledMonitoredItemsSamplingCount) throws UaException {
        BaseDataVariableTypeNode node = this.getDisabledMonitoredItemsSamplingCountNode();
        node.setValue(new Variant((Object)disabledMonitoredItemsSamplingCount));
    }

    @Override
    public UInteger readDisabledMonitoredItemsSamplingCount() throws UaException {
        try {
            return this.readDisabledMonitoredItemsSamplingCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDisabledMonitoredItemsSamplingCount(UInteger disabledMonitoredItemsSamplingCount) throws UaException {
        try {
            this.writeDisabledMonitoredItemsSamplingCountAsync(disabledMonitoredItemsSamplingCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readDisabledMonitoredItemsSamplingCountAsync() {
        return ((CompletableFuture)this.getDisabledMonitoredItemsSamplingCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDisabledMonitoredItemsSamplingCountAsync(UInteger disabledMonitoredItemsSamplingCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)disabledMonitoredItemsSamplingCount));
        return this.getDisabledMonitoredItemsSamplingCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDisabledMonitoredItemsSamplingCountNode() throws UaException {
        try {
            return this.getDisabledMonitoredItemsSamplingCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDisabledMonitoredItemsSamplingCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DisabledMonitoredItemsSamplingCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

