/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNodeProperties;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaVariableTypeNode
extends UaNode
implements VariableTypeNode {
    private DataValue value;
    private NodeId dataType;
    private Integer valueRank;
    private UInteger[] arrayDimensions;
    private Boolean isAbstract;

    public UaVariableTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    public synchronized DataValue getValue() {
        return this.value;
    }

    public synchronized NodeId getDataType() {
        return this.dataType;
    }

    public synchronized Integer getValueRank() {
        return this.valueRank;
    }

    public synchronized UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public synchronized Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public synchronized void setValue(DataValue value) {
        this.value = value;
    }

    public synchronized void setValue(Variant variant) {
        this.setValue(DataValue.valueOnly((Variant)variant));
    }

    public synchronized void setDataType(NodeId dataType) {
        this.dataType = dataType;
    }

    public synchronized void setValueRank(Integer valueRank) {
        this.valueRank = valueRank;
    }

    public synchronized void setArrayDimensions(UInteger[] arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }

    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public DataValue readValue() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Value);
        this.setValue(value);
        return value;
    }

    public NodeId readDataType() throws UaException {
        DataValue value = this.readAttribute(AttributeId.DataType);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read DataType failed");
        }
        NodeId dataType = (NodeId)value.getValue().getValue();
        this.setDataType(dataType);
        return dataType;
    }

    public Integer readValueRank() throws UaException {
        DataValue value = this.readAttribute(AttributeId.ValueRank);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read ValueRank failed");
        }
        Integer valueRank = (Integer)value.getValue().getValue();
        this.setValueRank(valueRank);
        return valueRank;
    }

    @Nullable
    public UInteger[] readArrayDimensions() throws UaException {
        DataValue value = this.readAttribute(AttributeId.ArrayDimensions);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad() && statusCode.getValue() != 2150957056L) {
            throw new UaException(statusCode, "read ArrayDimensions failed");
        }
        UInteger[] arrayDimensions = (UInteger[])value.getValue().getValue();
        this.setArrayDimensions(arrayDimensions);
        return arrayDimensions;
    }

    public Boolean readIsAbstract() throws UaException {
        DataValue value = this.readAttribute(AttributeId.IsAbstract);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read IsAbstract failed");
        }
        Boolean isAbstract = (Boolean)value.getValue().getValue();
        this.setIsAbstract(isAbstract);
        return isAbstract;
    }

    public void writeValue(DataValue value) throws UaException {
        StatusCode statusCode = this.writeAttribute(AttributeId.Value, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write Value failed");
        }
        this.setValue(value);
    }

    public void writeValue(Variant variant) throws UaException {
        this.writeValue(DataValue.valueOnly((Variant)variant));
    }

    public void writeDataType(NodeId dataType) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataType));
        StatusCode statusCode = this.writeAttribute(AttributeId.DataType, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write DataType failed");
        }
        this.setDataType(dataType);
    }

    public void writeValueRank(Integer valueRank) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)valueRank));
        StatusCode statusCode = this.writeAttribute(AttributeId.ValueRank, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write ValueRank failed");
        }
        this.setValueRank(valueRank);
    }

    public void writeArrayDimensions(UInteger[] arrayDimensions) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)arrayDimensions));
        StatusCode statusCode = this.writeAttribute(AttributeId.ArrayDimensions, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write ArrayDimensions failed");
        }
        this.setArrayDimensions(arrayDimensions);
    }

    public void writeIsAbstract(Boolean isAbstract) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)isAbstract));
        StatusCode statusCode = this.writeAttribute(AttributeId.IsAbstract, value);
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "write IsAbstract failed");
        }
        this.setIsAbstract(isAbstract);
    }

    public CompletableFuture<? extends String> readNodeVersionAsync() {
        return this.getProperty(VariableTypeNodeProperties.NodeVersion);
    }

    public CompletableFuture<StatusCode> writeNodeVersionAsync(String nodeVersion) {
        return this.setProperty(VariableTypeNodeProperties.NodeVersion, nodeVersion);
    }

    @Override
    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case Value: {
                return DataValue.valueOnly((Variant)new Variant(this.getValue().getValue().getValue()));
            }
            case DataType: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getDataType()));
            }
            case ValueRank: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getValueRank()));
            }
            case ArrayDimensions: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getArrayDimensions()));
            }
            case IsAbstract: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getIsAbstract()));
            }
        }
        return super.getAttributeValue(attributeId);
    }

    @Override
    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case Value: {
                this.setValue(value);
                break;
            }
            case DataType: {
                this.setDataType((NodeId)value.getValue().getValue());
                break;
            }
            case ValueRank: {
                this.setValueRank((Integer)value.getValue().getValue());
                break;
            }
            case ArrayDimensions: {
                this.setArrayDimensions((UInteger[])value.getValue().getValue());
                break;
            }
            case IsAbstract: {
                this.setIsAbstract((Boolean)value.getValue().getValue());
                break;
            }
            default: {
                super.setAttributeValue(attributeId, value);
            }
        }
    }
}

