/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.client.subscriptions.BatchItemResult;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscription;
import org.eclipse.milo.opcua.sdk.server.util.GroupMapCollate;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class BatchModifyMonitoredItems {
    private final Map<OpcUaMonitoredItem, BatchModifyParametersBuilder> buildersByItem = Collections.synchronizedMap(new LinkedHashMap());
    private final ListMultimap<OpcUaMonitoredItem, CompletableFuture<ModifyMonitoredItemResult>> futuresByItem = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final List<CompletableFuture<ModifyMonitoredItemResult>> resultFutures = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger serviceInvocationCount = new AtomicInteger(0);
    private final OpcUaClient client;
    private final OpcUaSubscription subscription;

    public BatchModifyMonitoredItems(ManagedSubscription subscription) {
        this(subscription.getClient(), subscription.getSubscription());
    }

    public BatchModifyMonitoredItems(OpcUaClient client, OpcUaSubscription subscription) {
        this.client = client;
        this.subscription = subscription;
    }

    public int getServiceInvocationCount() {
        return this.serviceInvocationCount.get();
    }

    public CompletableFuture<ModifyMonitoredItemResult> add(OpcUaMonitoredItem monitoredItem, Consumer<BatchModifyParametersBuilder> builderConsumer) {
        BatchModifyParametersBuilder builder = this.buildersByItem.computeIfAbsent(monitoredItem, BatchModifyMonitoredItems::parametersBuilderFromItem);
        builderConsumer.accept(builder);
        CompletableFuture<ModifyMonitoredItemResult> future = new CompletableFuture<ModifyMonitoredItemResult>();
        this.futuresByItem.put((Object)monitoredItem, future);
        this.resultFutures.add(future);
        return future;
    }

    public List<ModifyMonitoredItemResult> execute() throws InterruptedException {
        try {
            return this.executeAsync().get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public CompletableFuture<List<ModifyMonitoredItemResult>> executeAsync() {
        return BatchModifyMonitoredItems.readOperationLimit(this.client).thenCompose(this::executeAsync);
    }

    private CompletableFuture<List<ModifyMonitoredItemResult>> executeAsync(UInteger operationLimit) {
        List allMonitoringParameters = this.buildersByItem.values().stream().map(rec$ -> ((BatchModifyParametersBuilder)rec$).build()).collect(Collectors.toList());
        CompletableFuture resultsFuture = GroupMapCollate.groupMapCollate(allMonitoringParameters, parametersItem -> parametersItem.timestamps, timestampsKey -> parameterGroup -> {
            List itemsToModify = parameterGroup.stream().map(parameters -> new MonitoredItemModifyRequest(parameters.item.getMonitoredItemId(), new MonitoringParameters(parameters.clientHandle, parameters.samplingInterval, parameters.filter, parameters.queueSize, parameters.discardOldest))).collect(Collectors.toList());
            List partitionFutures = Lists.partition(itemsToModify, (int)operationLimit.intValue()).stream().map(partition -> this.modifyItemsAsync((TimestampsToReturn)timestampsKey, (List<MonitoredItemModifyRequest>)partition)).collect(Collectors.toList());
            return FutureUtils.flatSequence(partitionFutures);
        });
        return resultsFuture.thenCompose(results -> {
            ArrayList<OpcUaMonitoredItem> items = new ArrayList<OpcUaMonitoredItem>(this.buildersByItem.keySet());
            assert (items.size() == results.size());
            for (int i = 0; i < items.size(); ++i) {
                ArrayList futures;
                OpcUaMonitoredItem item = (OpcUaMonitoredItem)items.get(i);
                ModifyMonitoredItemResult result = (ModifyMonitoredItemResult)results.get(i);
                ListMultimap<OpcUaMonitoredItem, CompletableFuture<ModifyMonitoredItemResult>> listMultimap = this.futuresByItem;
                synchronized (listMultimap) {
                    futures = new ArrayList(this.futuresByItem.get((Object)item));
                }
                futures.forEach(f -> f.complete(result));
            }
            return FutureUtils.sequence(this.resultFutures);
        });
    }

    private CompletableFuture<List<ModifyMonitoredItemResult>> modifyItemsAsync(TimestampsToReturn timestamps, List<MonitoredItemModifyRequest> itemsToModify) {
        this.serviceInvocationCount.incrementAndGet();
        CompletableFuture<List<StatusCode>> modifyResults = this.subscription.modifyMonitoredItems(timestamps, itemsToModify);
        CompletionStage batchItemResults = modifyResults.thenApply(statusCodes -> statusCodes.stream().map(statusCode -> new ModifyMonitoredItemResult(StatusCode.GOOD, (StatusCode)statusCode)).collect(Collectors.toList()));
        return ((CompletableFuture)batchItemResults).exceptionally(ex -> {
            StatusCode serviceResult = UaException.extractStatusCode((Throwable)ex).orElse(new StatusCode(0x80010000L));
            ModifyMonitoredItemResult result = new ModifyMonitoredItemResult(serviceResult);
            return Collections.nCopies(itemsToModify.size(), result);
        });
    }

    private static BatchModifyParametersBuilder parametersBuilderFromItem(OpcUaMonitoredItem item) {
        return new BatchModifyParametersBuilder(item).setTimestamps(item.getTimestamps()).setClientHandle(item.getClientHandle()).setSamplingInterval(item.getRevisedSamplingInterval()).setFilter(item.getMonitoringFilter()).setQueueSize(item.getRevisedQueueSize()).setDiscardOldest(item.getDiscardOldest());
    }

    private static CompletableFuture<UInteger> readOperationLimit(OpcUaClient client) {
        CompletableFuture<UaVariableNode> nodeFuture = client.getAddressSpace().getVariableNodeAsync(Identifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall);
        return nodeFuture.thenCompose(variableNode -> ((CompletableFuture)variableNode.readAttributeAsync(AttributeId.Value).thenApply(v -> (UInteger)v.getValue().getValue())).exceptionally(ex -> Unsigned.uint((int)1000)));
    }

    public static class BatchModifyParametersBuilder {
        private TimestampsToReturn timestamps;
        private UInteger clientHandle;
        private Double samplingInterval;
        private ExtensionObject filter;
        private UInteger queueSize;
        private Boolean discardOldest;
        private final OpcUaMonitoredItem item;

        public BatchModifyParametersBuilder(OpcUaMonitoredItem item) {
            this.item = item;
        }

        public BatchModifyParametersBuilder setTimestamps(TimestampsToReturn timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public BatchModifyParametersBuilder setClientHandle(UInteger clientHandle) {
            this.clientHandle = clientHandle;
            return this;
        }

        public BatchModifyParametersBuilder setSamplingInterval(double samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public BatchModifyParametersBuilder setFilter(ExtensionObject filter) {
            this.filter = filter;
            return this;
        }

        public BatchModifyParametersBuilder setQueueSize(UInteger queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public BatchModifyParametersBuilder setDiscardOldest(boolean discardOldest) {
            this.discardOldest = discardOldest;
            return this;
        }

        private BatchModifyParameters build() {
            return new BatchModifyParameters(this.item, this.timestamps, this.clientHandle, this.samplingInterval, this.filter, this.queueSize, this.discardOldest);
        }
    }

    private static class BatchModifyParameters {
        final OpcUaMonitoredItem item;
        final TimestampsToReturn timestamps;
        final UInteger clientHandle;
        final Double samplingInterval;
        final ExtensionObject filter;
        final UInteger queueSize;
        final Boolean discardOldest;

        BatchModifyParameters(OpcUaMonitoredItem item, TimestampsToReturn timestamps, UInteger clientHandle, Double samplingInterval, ExtensionObject filter, UInteger queueSize, Boolean discardOldest) {
            this.item = item;
            this.timestamps = timestamps;
            this.clientHandle = clientHandle;
            this.samplingInterval = samplingInterval;
            this.filter = filter;
            this.queueSize = queueSize;
            this.discardOldest = discardOldest;
        }
    }

    public static class ModifyMonitoredItemResult
    implements BatchItemResult<StatusCode> {
        private final StatusCode serviceResult;
        private final StatusCode operationResult;

        public ModifyMonitoredItemResult(StatusCode serviceResult) {
            this(serviceResult, null);
        }

        ModifyMonitoredItemResult(StatusCode serviceResult, @Nullable StatusCode operationResult) {
            this.serviceResult = serviceResult;
            this.operationResult = operationResult;
        }

        @Override
        public StatusCode serviceResult() {
            return this.serviceResult;
        }

        @Override
        public Optional<StatusCode> operationResult() {
            return Optional.ofNullable(this.operationResult);
        }

        public boolean isServiceResultGood() {
            return this.serviceResult.isGood();
        }

        public boolean isOperationResultGood() {
            return this.operationResult().map(StatusCode::isGood).orElse(false);
        }
    }
}

