/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscriptionManager;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedDataItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedEventItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscription;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ManagedSubscription {
    public static final double DEFAULT_PUBLISHING_INTERVAL = 1000.0;
    public static final double DEFAULT_SAMPLING_INTERVAL = 1000.0;
    public static final UInteger DEFAULT_QUEUE_SIZE = Unsigned.uint((int)2);
    private final CopyOnWriteArrayList<ChangeListener> changeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StatusListener> statusListeners = new CopyOnWriteArrayList();
    private final Map<UInteger, ManagedDataItem> dataItems = new ConcurrentHashMap<UInteger, ManagedDataItem>();
    private final Map<UInteger, ManagedEventItem> eventItems = new ConcurrentHashMap<UInteger, ManagedEventItem>();
    private MonitoringMode defaultMonitoringMode = MonitoringMode.Reporting;
    private double defaultSamplingInterval = 1000.0;
    private UInteger defaultQueueSize = DEFAULT_QUEUE_SIZE;
    private TimestampsToReturn defaultTimestamps = TimestampsToReturn.Both;
    private ExtensionObject defaultDataFilter = null;
    private boolean defaultDiscardOldest = true;
    private final OpcUaClient client;
    private final OpcUaSubscription subscription;

    public ManagedSubscription(OpcUaClient client, OpcUaSubscription subscription) {
        this.client = client;
        this.subscription = subscription;
        subscription.addNotificationListener(new ManagedSubscriptionNotificationListener());
    }

    public OpcUaClient getClient() {
        return this.client;
    }

    public OpcUaSubscription getSubscription() {
        return this.subscription;
    }

    public List<ManagedDataItem> getDataItems() {
        return new ArrayList<ManagedDataItem>(this.dataItems.values());
    }

    public List<ManagedEventItem> getEventItems() {
        return new ArrayList<ManagedEventItem>(this.eventItems.values());
    }

    public ManagedDataItem createDataItem(NodeId nodeId) throws UaException {
        return this.createDataItems(Collections.singletonList(nodeId)).get(0);
    }

    public ManagedDataItem createDataItem(NodeId nodeId, Consumer<ManagedDataItem> consumer) throws UaException {
        return this.createDataItems(Collections.singletonList(nodeId), consumer).get(0);
    }

    public List<ManagedDataItem> createDataItems(List<NodeId> nodeIds) throws UaException {
        return this.createDataItems(nodeIds, (ManagedDataItem item) -> {});
    }

    public List<ManagedDataItem> createDataItems(List<NodeId> nodeIds, Consumer<ManagedDataItem> consumer) throws UaException {
        List<ReadValueId> readValueIds = nodeIds.stream().map(nodeId -> new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        return this.createDataItems(this.getDefaultSamplingInterval(), readValueIds, consumer);
    }

    public ManagedDataItem createDataItem(double samplingInterval, ReadValueId readValueId) throws UaException {
        return this.createDataItem(samplingInterval, readValueId, item -> {});
    }

    public ManagedDataItem createDataItem(double samplingInterval, ReadValueId readValueId, Consumer<ManagedDataItem> consumer) throws UaException {
        return this.createDataItems(samplingInterval, Collections.singletonList(readValueId), consumer).get(0);
    }

    public List<ManagedDataItem> createDataItems(double samplingInterval, List<ReadValueId> readValueIds) throws UaException {
        return this.createDataItems(samplingInterval, readValueIds, item -> {});
    }

    public List<ManagedDataItem> createDataItems(double samplingInterval, List<ReadValueId> readValueIds, Consumer<ManagedDataItem> consumer) throws UaException {
        try {
            CompletableFuture<List<ManagedDataItem>> future = this.createDataItemsAsync(samplingInterval, readValueIds, consumer);
            return future.get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<List<ManagedDataItem>> createDataItemsAsync(double samplingInterval, List<ReadValueId> readValueIds) {
        return this.createDataItemsAsync(samplingInterval, readValueIds, item -> {});
    }

    public CompletableFuture<List<ManagedDataItem>> createDataItemsAsync(double samplingInterval, List<ReadValueId> readValueIds, Consumer<ManagedDataItem> consumer) {
        ExtensionObject filter = this.getDefaultDataFilter();
        UInteger queueSize = this.getDefaultQueueSize();
        boolean discardOldest = this.getDefaultDiscardOldest();
        List<MonitoredItemCreateRequest> createRequests = readValueIds.stream().map(readValueId -> {
            MonitoringParameters parameters = new MonitoringParameters(this.subscription.nextClientHandle(), Double.valueOf(samplingInterval), filter, queueSize, Boolean.valueOf(discardOldest));
            return new MonitoredItemCreateRequest(readValueId, this.getDefaultMonitoringMode(), parameters);
        }).collect(Collectors.toList());
        CompletableFuture<List<UaMonitoredItem>> monitoredItems = this.subscription.createMonitoredItems(this.getDefaultTimestamps(), createRequests, (item, id) -> {
            ManagedDataItem dataItem = this.createAndTrackDataItem((UaMonitoredItem)item);
            consumer.accept(dataItem);
        });
        return monitoredItems.thenApply(items -> items.stream().map(item -> this.dataItems.get(item.getClientHandle())).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void deleteDataItem(ManagedDataItem dataItem) throws UaException {
        this.deleteDataItems(Collections.singletonList(dataItem));
    }

    public void deleteDataItems(List<ManagedDataItem> dataItems) throws UaException {
        try {
            this.deleteDataItemsAsync(dataItems).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> deleteDataItemAsync(ManagedDataItem dataItem) {
        return this.deleteDataItemsAsync(Collections.singletonList(dataItem));
    }

    public CompletableFuture<Unit> deleteDataItemsAsync(List<ManagedDataItem> dataItemsToDelete) {
        List<UaMonitoredItem> monitoredItems = dataItemsToDelete.stream().map(ManagedItem::getMonitoredItem).collect(Collectors.toList());
        return this.subscription.deleteMonitoredItems(monitoredItems).thenCompose(statusCodes -> {
            for (UaMonitoredItem monitoredItem : monitoredItems) {
                this.dataItems.remove(monitoredItem.getClientHandle());
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    private ManagedDataItem createAndTrackDataItem(UaMonitoredItem item) {
        ManagedDataItem dataItem = new ManagedDataItem(this.client, this, (OpcUaMonitoredItem)item);
        this.dataItems.put(item.getClientHandle(), dataItem);
        return dataItem;
    }

    public ManagedEventItem createEventItem(NodeId nodeId, EventFilter eventFilter) throws UaException {
        return this.createEventItem(nodeId, eventFilter, item -> {});
    }

    public ManagedEventItem createEventItem(NodeId nodeId, EventFilter eventFilter, Consumer<ManagedEventItem> consumer) throws UaException {
        return this.createEventItems(Collections.singletonList(nodeId), Collections.singletonList(eventFilter), consumer).get(0);
    }

    public List<ManagedEventItem> createEventItems(List<NodeId> nodeIds, List<EventFilter> eventFilters) throws UaException {
        return this.createEventItems(nodeIds, eventFilters, item -> {});
    }

    public List<ManagedEventItem> createEventItems(List<NodeId> nodeIds, List<EventFilter> eventFilters, Consumer<ManagedEventItem> consumer) throws UaException {
        try {
            CompletableFuture<List<ManagedEventItem>> future = this.createEventItemsAsync(nodeIds, eventFilters, consumer);
            return future.get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<List<ManagedEventItem>> createEventItemsAsync(List<NodeId> nodeIds, List<EventFilter> eventFilters) {
        return this.createEventItemsAsync(nodeIds, eventFilters, item -> {});
    }

    public CompletableFuture<List<ManagedEventItem>> createEventItemsAsync(List<NodeId> nodeIds, List<EventFilter> eventFilters, Consumer<ManagedEventItem> consumer) {
        UInteger queueSize = this.getDefaultQueueSize();
        boolean discardOldest = this.getDefaultDiscardOldest();
        ArrayList<MonitoredItemCreateRequest> createRequests = new ArrayList<MonitoredItemCreateRequest>();
        for (int i = 0; i < nodeIds.size(); ++i) {
            ReadValueId readValueId = new ReadValueId(nodeIds.get(i), AttributeId.EventNotifier.uid(), null, QualifiedName.NULL_VALUE);
            MonitoringParameters parameters = new MonitoringParameters(this.subscription.nextClientHandle(), Double.valueOf(0.0), ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)((UaStructure)eventFilters.get(i))), queueSize, Boolean.valueOf(discardOldest));
            createRequests.add(new MonitoredItemCreateRequest(readValueId, this.getDefaultMonitoringMode(), parameters));
        }
        CompletableFuture<List<UaMonitoredItem>> monitoredItems = this.subscription.createMonitoredItems(this.getDefaultTimestamps(), createRequests, (item, id) -> {
            ManagedEventItem eventItem = this.createAndTrackEventItem((UaMonitoredItem)item);
            consumer.accept(eventItem);
        });
        return monitoredItems.thenApply(items -> items.stream().map(item -> this.eventItems.get(item.getClientHandle())).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void deleteEventItem(ManagedEventItem eventItem) throws UaException {
        this.deleteEventItems(Collections.singletonList(eventItem));
    }

    public void deleteEventItems(List<ManagedEventItem> eventItems) throws UaException {
        try {
            this.deleteEventItemsAsync(eventItems).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> deleteEventItemAsync(ManagedEventItem eventItem) {
        return this.deleteEventItemsAsync(Collections.singletonList(eventItem));
    }

    public CompletableFuture<Unit> deleteEventItemsAsync(List<ManagedEventItem> eventItemsToDelete) {
        List<UaMonitoredItem> monitoredItems = eventItemsToDelete.stream().map(ManagedItem::getMonitoredItem).collect(Collectors.toList());
        return this.subscription.deleteMonitoredItems(monitoredItems).thenCompose(statusCodes -> {
            for (UaMonitoredItem monitoredItem : monitoredItems) {
                this.eventItems.remove(monitoredItem.getClientHandle());
            }
            return CompletableFuture.completedFuture(Unit.VALUE);
        });
    }

    private ManagedEventItem createAndTrackEventItem(UaMonitoredItem item) {
        ManagedEventItem eventItem = new ManagedEventItem(this.client, this, (OpcUaMonitoredItem)item);
        this.eventItems.put(item.getClientHandle(), eventItem);
        return eventItem;
    }

    public double getPublishingInterval() {
        return this.subscription.getRevisedPublishingInterval();
    }

    public double setPublishingInterval(double publishingInterval) throws UaException {
        try {
            CompletableFuture<Double> future = this.setPublishingIntervalAsync(publishingInterval);
            return future.get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Double> setPublishingIntervalAsync(double publishingInterval) {
        CompletableFuture<UaSubscription> future = this.client.getSubscriptionManager().modifySubscription(this.subscription.getSubscriptionId(), publishingInterval);
        return future.thenApply(UaSubscription::getRevisedPublishingInterval);
    }

    public boolean isPublishingEnabled() {
        return this.subscription.isPublishingEnabled();
    }

    public void setPublishingEnabled(boolean enabled) throws UaException {
        try {
            this.setPublishingEnabledAsync(enabled).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> setPublishingEnabledAsync(boolean enabled) {
        return this.subscription.setPublishingMode(enabled).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public synchronized MonitoringMode getDefaultMonitoringMode() {
        return this.defaultMonitoringMode;
    }

    public synchronized void setDefaultMonitoringMode(MonitoringMode defaultMonitoringMode) {
        this.defaultMonitoringMode = defaultMonitoringMode;
    }

    public synchronized double getDefaultSamplingInterval() {
        return this.defaultSamplingInterval;
    }

    public synchronized void setDefaultSamplingInterval(double defaultSamplingInterval) {
        this.defaultSamplingInterval = defaultSamplingInterval;
    }

    public synchronized UInteger getDefaultQueueSize() {
        return this.defaultQueueSize;
    }

    public synchronized void setDefaultQueueSize(UInteger defaultQueueSize) {
        this.defaultQueueSize = defaultQueueSize;
    }

    @Nullable
    public synchronized ExtensionObject getDefaultDataFilter() {
        return this.defaultDataFilter;
    }

    public synchronized void setDefaultDataFilter(@Nullable DataChangeFilter defaultDataFilter) {
        this.defaultDataFilter = defaultDataFilter != null ? ExtensionObject.encode((SerializationContext)this.client.getSerializationContext(), (UaStructure)defaultDataFilter) : null;
    }

    public synchronized TimestampsToReturn getDefaultTimestamps() {
        return this.defaultTimestamps;
    }

    public synchronized void setDefaultTimestamps(TimestampsToReturn defaultTimestamps) {
        this.defaultTimestamps = defaultTimestamps;
    }

    public synchronized boolean getDefaultDiscardOldest() {
        return this.defaultDiscardOldest;
    }

    public synchronized void setDefaultDiscardOldest(boolean defaultDiscardOldest) {
        this.defaultDiscardOldest = defaultDiscardOldest;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public boolean removeChangeListener(ChangeListener changeListener) {
        return this.changeListeners.remove(changeListener);
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListeners.add(statusListener);
    }

    public boolean removeStatusListener(StatusListener statusListener) {
        return this.statusListeners.remove(statusListener);
    }

    public ChangeListener addDataChangeListener(final BiConsumer<List<ManagedDataItem>, List<DataValue>> biConsumer) {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void onDataReceived(List<ManagedDataItem> dataItems, List<DataValue> dataValues) {
                biConsumer.accept(dataItems, dataValues);
            }
        };
        this.addChangeListener(changeListener);
        return changeListener;
    }

    public ChangeListener addEventChangeListener(final BiConsumer<List<ManagedEventItem>, List<Variant[]>> biConsumer) {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void onEventReceived(List<ManagedEventItem> eventItems, List<Variant[]> eventFields) {
                biConsumer.accept(eventItems, eventFields);
            }
        };
        this.addChangeListener(changeListener);
        return changeListener;
    }

    public void delete() throws UaException {
        try {
            this.deleteAsync().get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> deleteAsync() {
        return this.client.getSubscriptionManager().deleteSubscription(this.subscription.getSubscriptionId()).thenApply(s -> Unit.VALUE);
    }

    public static ManagedSubscription create(OpcUaClient client) throws UaException {
        return ManagedSubscription.create(client, 1000.0);
    }

    public static ManagedSubscription create(OpcUaClient client, double publishingInterval) throws UaException {
        try {
            return ManagedSubscription.createAsync(client, publishingInterval).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public static CompletableFuture<ManagedSubscription> createAsync(OpcUaClient client, double publishingInterval) {
        CompletableFuture<UaSubscription> future = client.getSubscriptionManager().createSubscription(publishingInterval);
        return future.thenApply(subscription -> new ManagedSubscription(client, (OpcUaSubscription)subscription));
    }

    private class ManagedSubscriptionNotificationListener
    implements UaSubscriptionManager.SubscriptionListener,
    UaSubscription.NotificationListener {
        private final ExecutionQueue executionQueue;

        private ManagedSubscriptionNotificationListener() {
            this.executionQueue = new ExecutionQueue((Executor)ManagedSubscription.this.client.getConfig().getExecutor());
        }

        @Override
        public void onDataChangeNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<DataValue> dataValues, DateTime publishTime) {
            ArrayList<ManagedDataItem> itemsToNotify = new ArrayList<ManagedDataItem>(monitoredItems.size());
            ArrayList<DataValue> valuesToNotify = new ArrayList<DataValue>(monitoredItems.size());
            for (int i = 0; i < monitoredItems.size(); ++i) {
                UInteger key = monitoredItems.get(i).getClientHandle();
                ManagedDataItem dataItem = (ManagedDataItem)ManagedSubscription.this.dataItems.get(key);
                if (dataItem == null) continue;
                itemsToNotify.add(dataItem);
                valuesToNotify.add(dataValues.get(i));
            }
            ManagedSubscription.this.changeListeners.forEach(changeListener -> changeListener.onDataReceived(itemsToNotify, valuesToNotify));
        }

        @Override
        public void onEventNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<Variant[]> eventFields, DateTime publishTime) {
            ArrayList<ManagedEventItem> itemsToNotify = new ArrayList<ManagedEventItem>(monitoredItems.size());
            ArrayList<Variant[]> fieldsToNotify = new ArrayList<Variant[]>(monitoredItems.size());
            for (int i = 0; i < monitoredItems.size(); ++i) {
                UInteger key = monitoredItems.get(i).getClientHandle();
                ManagedEventItem eventItem = (ManagedEventItem)ManagedSubscription.this.eventItems.get(key);
                if (eventItem == null) continue;
                itemsToNotify.add(eventItem);
                fieldsToNotify.add(eventFields.get(i));
            }
            ManagedSubscription.this.changeListeners.forEach(changeListener -> changeListener.onEventReceived(itemsToNotify, fieldsToNotify));
        }

        @Override
        public void onKeepAliveNotification(UaSubscription subscription, DateTime publishTime) {
            ManagedSubscription.this.changeListeners.forEach(ChangeListener::onKeepAliveReceived);
        }

        @Override
        public void onStatusChangedNotification(UaSubscription subscription, StatusCode status) {
            this.executionQueue.submit(() -> ManagedSubscription.this.statusListeners.forEach(statusListener -> statusListener.onSubscriptionStatusChanged(ManagedSubscription.this, status)));
        }

        @Override
        public void onNotificationDataLost(UaSubscription subscription) {
            if (ManagedSubscription.this.subscription.getSubscriptionId().equals((Object)subscription.getSubscriptionId())) {
                this.executionQueue.submit(() -> ManagedSubscription.this.statusListeners.forEach(statusListener -> statusListener.onNotificationDataLost(ManagedSubscription.this)));
            }
        }

        @Override
        public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
            if (ManagedSubscription.this.subscription.getSubscriptionId().equals((Object)subscription.getSubscriptionId())) {
                this.executionQueue.submit(() -> ManagedSubscription.this.statusListeners.forEach(statusListener -> statusListener.onSubscriptionTransferFailed(ManagedSubscription.this, statusCode)));
            }
        }
    }

    public static interface StatusListener {
        default public void onNotificationDataLost(ManagedSubscription subscription) {
            subscription.getClient().call(new CallMethodRequest(Identifiers.Server, Identifiers.Server_ResendData, new Variant[]{new Variant((Object)subscription.getSubscription().getSubscriptionId())}));
        }

        default public void onSubscriptionStatusChanged(ManagedSubscription subscription, StatusCode statusCode) {
        }

        default public void onSubscriptionTransferFailed(ManagedSubscription subscription, StatusCode statusCode) {
        }
    }

    public static interface ChangeListener {
        default public void onDataReceived(List<ManagedDataItem> dataItems, List<DataValue> dataValues) {
        }

        default public void onEventReceived(List<ManagedEventItem> eventItems, List<Variant[]> eventFields) {
        }

        default public void onKeepAliveReceived() {
        }
    }
}

