/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jetbrains.annotations.Nullable;

public class NodeCache {
    private final Cache<NodeId, UaNode> cachedNodes;
    private final ConcurrentMap<NodeId, UaNode> canonicalNodes;

    public NodeCache() {
        this(b -> {});
    }

    public NodeCache(Consumer<CacheBuilder<Object, Object>> consumer) {
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(16384L).recordStats();
        consumer.accept((CacheBuilder<Object, Object>)builder);
        this.cachedNodes = builder.build();
        this.canonicalNodes = new ConcurrentHashMap<NodeId, UaNode>();
    }

    public UaNode canonicalize(UaNode node) {
        NodeId nodeId = node.getNodeId();
        UaNode prev = this.canonicalNodes.putIfAbsent(nodeId, node);
        return prev != null ? prev : node;
    }

    @Nullable
    public UaNode getIfPresent(NodeId nodeId) {
        return this.canonicalNodes.getOrDefault(nodeId, (UaNode)this.cachedNodes.getIfPresent((Object)nodeId));
    }

    public void put(NodeId nodeId, UaNode node) {
        this.cachedNodes.put((Object)nodeId, (Object)node);
    }

    public void invalidate(NodeId nodeId) {
        this.canonicalNodes.remove(nodeId);
        this.cachedNodes.invalidate((Object)nodeId);
    }
}

