/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.config;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public interface OpcUaClientConfig
extends UaStackClientConfig {
    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public Supplier<String> getSessionName();

    public String[] getSessionLocaleIds();

    public UInteger getSessionTimeout();

    public UInteger getMaxResponseMessageSize();

    public UInteger getMaxPendingPublishRequests();

    public IdentityProvider getIdentityProvider();

    public UInteger getKeepAliveFailuresAllowed();

    public UInteger getKeepAliveInterval();

    public UInteger getKeepAliveTimeout();

    public static OpcUaClientConfigBuilder builder() {
        return new OpcUaClientConfigBuilder();
    }

    public static OpcUaClientConfigBuilder copy(OpcUaClientConfig config) {
        OpcUaClientConfigBuilder builder = new OpcUaClientConfigBuilder();
        builder.setEndpoint(config.getEndpoint());
        config.getKeyPair().ifPresent(builder::setKeyPair);
        config.getCertificate().ifPresent(builder::setCertificate);
        config.getCertificateChain().ifPresent(builder::setCertificateChain);
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setChannelLifetime(config.getChannelLifetime());
        builder.setExecutor(config.getExecutor());
        builder.setScheduledExecutor(config.getScheduledExecutor());
        builder.setEventLoop(config.getEventLoop());
        builder.setWheelTimer(config.getWheelTimer());
        builder.setConnectTimeout(config.getConnectTimeout());
        builder.setAcknowledgeTimeout(config.getAcknowledgeTimeout());
        builder.setRequestTimeout(config.getRequestTimeout());
        builder.setSessionName(config.getSessionName());
        builder.setSessionTimeout(config.getSessionTimeout());
        builder.setRequestTimeout(config.getRequestTimeout());
        builder.setMaxResponseMessageSize(config.getMaxResponseMessageSize());
        builder.setMaxPendingPublishRequests(config.getMaxPendingPublishRequests());
        builder.setIdentityProvider(config.getIdentityProvider());
        builder.setKeepAliveFailuresAllowed(config.getKeepAliveFailuresAllowed());
        builder.setKeepAliveInterval(config.getKeepAliveInterval());
        builder.setKeepAliveTimeout(config.getKeepAliveTimeout());
        builder.setSessionLocaleIds(config.getSessionLocaleIds());
        return builder;
    }

    public static OpcUaClientConfig copy(OpcUaClientConfig config, Consumer<OpcUaClientConfigBuilder> consumer) {
        OpcUaClientConfigBuilder builder = OpcUaClientConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

